/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.message.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.simantics.message.ILogListener;
import org.simantics.message.ILogger;
import org.simantics.message.internal.Activator;

final class Messages
implements ILogger {
    ListenerList listeners = new ListenerList();
    List<IStatus> queue = new ArrayList<IStatus>();

    Messages() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogListener(ILogListener listener) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            boolean firstListener = this.listeners.isEmpty();
            this.listeners.add((Object)listener);
            if (firstListener) {
                for (IStatus s : this.queue) {
                    listener.logging(s, "org.simantics.message");
                }
                this.queue.clear();
            }
        }
    }

    @Override
    public String getName() {
        return "Platform Log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(IStatus status) {
        Object[] ls;
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            ls = this.listeners.getListeners();
        }
        if (ls.length == 0) {
            this.queue.add(status);
            return;
        }
        Object[] objectArray = ls;
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            try {
                ((ILogListener)l).logging(status, "org.simantics.message");
            }
            catch (Exception e) {
                this.handleException(e);
            }
            catch (LinkageError e) {
                this.handleException(e);
            }
            ++n2;
        }
    }

    private void handleException(Throwable e) {
        if (!(e instanceof OperationCanceledException)) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.message", "Message logging failed, see exception for cause.", e));
        }
    }

    @Override
    public void removeLogListener(ILogListener listener) {
        this.listeners.remove((Object)listener);
    }
}

