/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx;

import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.simantics.utils.datastructures.Array;
import org.simantics.utils.ui.gfx.ImageCache;

public class CompositionImageDescriptor
extends ImageDescriptor {
    public static final PaletteData DEFAULT_PALETTEDATA = new PaletteData(0xFF0000, 65280, 255);
    ImageCache cache = ImageCache.getInstance();
    final Array<ImageDescriptor> ids;
    Point size;

    public static ImageDescriptor compose(ImageDescriptor ... imageDescriptors) {
        if (imageDescriptors.length == 1) {
            return imageDescriptors[0];
        }
        return new CompositionImageDescriptor(imageDescriptors);
    }

    public static ImageDescriptor compose(Collection<ImageDescriptor> imageDescriptors) {
        int size = imageDescriptors.size();
        if (size == 1) {
            return imageDescriptors.iterator().next();
        }
        return new CompositionImageDescriptor(imageDescriptors.toArray(new ImageDescriptor[size]));
    }

    public CompositionImageDescriptor(ImageDescriptor[] ids) {
        this.ids = new Array((Object[])ids);
        assert (this.ids.size() > 0);
        ImageDescriptor[] imageDescriptorArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDescriptor id = imageDescriptorArray[n2];
            assert (id != null);
            ++n2;
        }
    }

    public CompositionImageDescriptor(Array<ImageDescriptor> ids) {
        this.ids = ids;
        assert (this.ids.size() > 0);
        ImageDescriptor[] imageDescriptorArray = (ImageDescriptor[])ids.toArray();
        int n = imageDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDescriptor id = imageDescriptorArray[n2];
            assert (id != null);
            ++n2;
        }
    }

    public ImageData getImageData() {
        ImageDescriptor[] _ids = (ImageDescriptor[])this.ids.toArray();
        if (_ids.length == 1) {
            return this.cache.getImage(_ids[0]).getImageData();
        }
        Point s = this.getSize();
        PaletteData palette = DEFAULT_PALETTEDATA;
        ImageData id = new ImageData(s.x, s.y, 24, palette);
        id.setAlpha(0, 0, 0);
        int i = 0;
        while (i < _ids.length) {
            ImageData layer = ImageCache.getInstance().getImage(_ids[i]).getImageData();
            int width = Math.min(s.x, layer.width);
            int height = Math.min(s.y, layer.height);
            PaletteData layerPaletteData = layer.palette;
            if (layer.getTransparencyType() == 2 || layer.getTransparencyType() == 4) {
                ImageData mask = layer.getTransparencyMask();
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        if (mask.getPixel(x, y) == 1) {
                            RGB rgb = layerPaletteData.getRGB(layer.getPixel(x, y));
                            id.setPixel(x, y, palette.getPixel(rgb));
                            id.setAlpha(x, y, 255);
                        }
                        ++x;
                    }
                    ++y;
                }
            } else {
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        int layerAlpha = layer.getAlpha(x, y);
                        int origAlpha = id.getAlpha(x, y);
                        RGB layerRGB = layerPaletteData.getRGB(layer.getPixel(x, y));
                        RGB origRGB = palette.getRGB(id.getPixel(x, y));
                        int newR = (origRGB.red * (255 - layerAlpha) + layerRGB.red * layerAlpha) / 255;
                        int newG = (origRGB.green * (255 - layerAlpha) + layerRGB.green * layerAlpha) / 255;
                        int newB = (origRGB.blue * (255 - layerAlpha) + layerRGB.blue * layerAlpha) / 255;
                        int newAlpha = origAlpha + (255 - origAlpha) * layerAlpha / 255;
                        id.setPixel(x, y, palette.getPixel(new RGB(newR, newG, newB)));
                        id.setAlpha(x, y, newAlpha);
                        ++x;
                    }
                    ++y;
                }
            }
            ++i;
        }
        return id;
    }

    private Point _countSize() {
        int width = 0;
        int height = 0;
        ImageDescriptor[] imageDescriptorArray = (ImageDescriptor[])this.ids.toArray();
        int n = imageDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            int h;
            ImageDescriptor id = imageDescriptorArray[n2];
            Image i = this.cache.getImage(id);
            int w = i.getImageData().width;
            if (w > width) {
                width = w;
            }
            if ((h = i.getImageData().height) > height) {
                height = h;
            }
            ++n2;
        }
        return new Point(width, height);
    }

    protected Point getSize() {
        if (this.size == null) {
            this.size = this._countSize();
        }
        return this.size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompositionImageDescriptor)) {
            return false;
        }
        CompositionImageDescriptor other = (CompositionImageDescriptor)((Object)obj);
        return other.ids.equals(this.ids);
    }

    public int hashCode() {
        return this.ids.hashCode();
    }
}

