/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.color;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.simantics.utils.ui.color.Color;
import org.simantics.utils.ui.color.ColorGradient;
import org.simantics.utils.ui.color.ColorValue;

public class ColorAlphaGradient
extends ColorGradient {
    List<Integer> alphaValues;

    public ColorAlphaGradient() {
        this.alphaValues = new ArrayList<Integer>();
    }

    public ColorAlphaGradient(ColorAlphaGradient copyFrom) {
        super(copyFrom);
        this.alphaValues = copyFrom.alphaValues;
    }

    public ColorAlphaGradient(ColorValue[] array, int[] alphaArray) {
        super(array);
        if (array.length != alphaArray.length) {
            throw new IllegalArgumentException("Array lenghts do not match.");
        }
        this.alphaValues = new ArrayList<Integer>(alphaArray.length);
        int[] nArray = alphaArray;
        int n = alphaArray.length;
        int n2 = 0;
        while (n2 < n) {
            int a = nArray[n2];
            this.alphaValues.add(a);
            ++n2;
        }
    }

    public ColorAlphaGradient(ColorValue[] array, int[] alphaArray, int type) {
        super(array, type);
        if (array.length != alphaArray.length) {
            throw new IllegalArgumentException("Array lenghts do not match.");
        }
        this.alphaValues = new ArrayList<Integer>(alphaArray.length);
        int[] nArray = alphaArray;
        int n = alphaArray.length;
        int n2 = 0;
        while (n2 < n) {
            int a = nArray[n2];
            this.alphaValues.add(a);
            ++n2;
        }
    }

    public ColorAlphaGradient(Collection<ColorValue> values, Collection<Integer> alphaValues) {
        super(values);
        if (values.size() != alphaValues.size()) {
            throw new IllegalArgumentException("Array lenghts do not match.");
        }
        this.alphaValues = new ArrayList<Integer>(alphaValues);
    }

    public ColorAlphaGradient(Collection<ColorValue> values, Collection<Integer> alphaValues, int type) {
        super(values, type);
        if (values.size() != alphaValues.size()) {
            throw new IllegalArgumentException("Array lenghts do not match.");
        }
        this.alphaValues = new ArrayList<Integer>(alphaValues);
    }

    private byte[] getRGBColor(double value) {
        int index = 1;
        while (((ColorValue)this.values.get(index)).getValue() <= value && index < this.values.size() - 1) {
            ++index;
        }
        value -= ((ColorValue)this.values.get(index - 1)).getValue();
        double valuei = 1.0 - (value /= ((ColorValue)this.values.get(index)).getValue() - ((ColorValue)this.values.get(index - 1)).getValue());
        byte[] color = new byte[]{(byte)Math.min(255.0, Math.floor(value * (double)((ColorValue)this.values.get(index)).getColor().getR() + valuei * (double)((ColorValue)this.values.get(index - 1)).getColor().getR())), (byte)Math.min(255.0, Math.floor(value * (double)((ColorValue)this.values.get(index)).getColor().getG() + valuei * (double)((ColorValue)this.values.get(index - 1)).getColor().getG())), (byte)Math.min(255.0, Math.floor(value * (double)((ColorValue)this.values.get(index)).getColor().getB() + valuei * (double)((ColorValue)this.values.get(index - 1)).getColor().getB())), (byte)Math.min(255.0, Math.floor(value * (double)this.alphaValues.get(index).intValue() + valuei * (double)this.alphaValues.get(index - 1).intValue()))};
        return color;
    }

    private byte[] getHSVColor(double value) {
        double h;
        int index = 1;
        while (((ColorValue)this.values.get(index)).getValue() <= value && index < this.values.size() - 1) {
            ++index;
        }
        value -= ((ColorValue)this.values.get(index - 1)).getValue();
        double valuei = 1.0 - (value /= ((ColorValue)this.values.get(index)).getValue() - ((ColorValue)this.values.get(index - 1)).getValue());
        if (Float.isNaN(((ColorValue)this.values.get(index)).getColor().getH())) {
            h = ((ColorValue)this.values.get(index - 1)).getColor().getH();
        } else if (Float.isNaN(((ColorValue)this.values.get(index - 1)).getColor().getH())) {
            h = ((ColorValue)this.values.get(index)).getColor().getH();
        } else {
            float angle = ((ColorValue)this.values.get(index)).getColor().getH() - ((ColorValue)this.values.get(index - 1)).getColor().getH();
            if (angle > 180.0f) {
                angle -= 360.0f;
            } else if (angle < -180.0f) {
                angle += 360.0f;
            }
            h = (double)((ColorValue)this.values.get(index - 1)).getColor().getH() + value * (double)angle;
            if (h > 360.0) {
                h -= 360.0;
            } else if (h < 0.0) {
                h += 360.0;
            }
        }
        Color interpolated = new Color(h, value * (double)((ColorValue)this.values.get(index)).getColor().getS() + valuei * (double)((ColorValue)this.values.get(index - 1)).getColor().getS(), value * (double)((ColorValue)this.values.get(index)).getColor().getV() + valuei * (double)((ColorValue)this.values.get(index - 1)).getColor().getV());
        byte[] color = new byte[]{(byte)interpolated.getR(), (byte)interpolated.getG(), (byte)interpolated.getB(), (byte)Math.min(255.0, Math.floor(value * (double)this.alphaValues.get(index).intValue() + valuei * (double)this.alphaValues.get(index - 1).intValue()))};
        return color;
    }

    @Override
    public byte[] getGradientArray(int size) {
        byte[] array = new byte[size * 4];
        if (this.values.size() > 1) {
            int i = 0;
            while (i < size) {
                int index = i * 4;
                double value = ((ColorValue)this.values.get(0)).getValue() + (((ColorValue)this.values.get(this.values.size() - 1)).getValue() - ((ColorValue)this.values.get(0)).getValue()) * (double)i / (double)size;
                byte[] color = this.type == 0 ? this.getRGBColor(value) : this.getHSVColor(value);
                array[index] = color[0];
                array[index + 1] = color[1];
                array[index + 2] = color[2];
                array[index + 3] = color[3];
                ++i;
            }
        } else if (this.values.size() == 1) {
            byte[] color = new byte[]{(byte)((ColorValue)this.values.get(0)).getColor().getR(), (byte)((ColorValue)this.values.get(0)).getColor().getG(), (byte)((ColorValue)this.values.get(0)).getColor().getB()};
            color[3] = (byte)this.alphaValues.get(0).intValue();
            int i = 0;
            while (i < size) {
                int index = i * 3;
                array[index] = color[0];
                array[index + 1] = color[1];
                array[index + 2] = color[2];
                array[index + 3] = color[3];
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                int index = i * 4;
                array[index] = -1;
                array[index + 1] = -1;
                array[index + 2] = -1;
                array[index + 3] = -1;
                ++i;
            }
        }
        return array;
    }

    @Override
    public Image getGradientImage(int width, int height, int style) {
        Image image = new Image((Device)Display.getCurrent(), width, height);
        GC gc = new GC((Drawable)image);
        gc.setBackground(Display.getCurrent().getSystemColor(1));
        gc.fillRectangle(0, 0, width, height);
        if (this.values.size() > 1) {
            if (256 == (style | 0x100)) {
                int x = 0;
                while (x < width) {
                    double value = ((ColorValue)this.values.get(0)).getValue() + (((ColorValue)this.values.get(this.values.size() - 1)).getValue() - ((ColorValue)this.values.get(0)).getValue()) * (double)x / (double)(width - 1);
                    byte[] byteColor = this.type == 0 ? this.getRGBColor(value) : this.getHSVColor(value);
                    org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), byteColor[0] & 0xFF, byteColor[1] & 0xFF, byteColor[2] & 0xFF, byteColor[3] & 0xFF);
                    gc.setForeground(color);
                    gc.drawLine(x, 0, x, height);
                    color.dispose();
                    ++x;
                }
            } else if (512 == (style | 0x200)) {
                int y = 0;
                while (y < height) {
                    double value = ((ColorValue)this.values.get(0)).getValue() + (((ColorValue)this.values.get(this.values.size() - 1)).getValue() - ((ColorValue)this.values.get(0)).getValue()) * (double)y / (double)(height - 1);
                    byte[] byteColor = this.type == 0 ? this.getRGBColor(value) : this.getHSVColor(value);
                    org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), byteColor[0] & 0xFF, byteColor[1] & 0xFF, byteColor[2] & 0xFF, byteColor[3] & 0xFF);
                    gc.setForeground(color);
                    gc.drawLine(0, y, width, y);
                    color.dispose();
                    ++y;
                }
            } else {
                gc.dispose();
                image.dispose();
                SWT.error((int)5);
            }
        } else if (this.values.size() == 1) {
            org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), ((ColorValue)this.values.get(0)).getColor().getR(), ((ColorValue)this.values.get(0)).getColor().getG(), ((ColorValue)this.values.get(0)).getColor().getB(), this.alphaValues.get(0).intValue());
            gc.setBackground(color);
            gc.fillRectangle(0, 0, width, height);
            color.dispose();
        } else {
            gc.fillRectangle(0, 0, width, height);
        }
        gc.dispose();
        return image;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            ColorAlphaGradient cg = (ColorAlphaGradient)obj;
            return this.alphaValues.containsAll(cg.alphaValues);
        }
        return false;
    }
}

