/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx;

import org.simantics.utils.ui.gfx.PixelDimension;

public class PhysicalDimension {
    public final double width;
    public final double height;
    private final int hash;

    public PhysicalDimension(double width, double height) {
        this.width = width;
        this.height = height;
        this.hash = PhysicalDimension.makeHash(width, height);
    }

    public PhysicalDimension(PixelDimension d) {
        this(d.width, d.height);
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PixelDimension)) {
            return false;
        }
        PixelDimension d = (PixelDimension)obj;
        return this.width == (double)d.width && this.height == (double)d.height;
    }

    public int hashCode() {
        return this.hash;
    }

    private static int makeHash(Double w, Double h) {
        return w.hashCode() ^ h.hashCode() * 7;
    }

    public String toString() {
        return "PhysicalDimension [w=" + this.width + ", h=" + this.height + "]";
    }

    public double getAspectRatio() {
        return this.width / this.height;
    }
}

