/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ShowMessage
implements Runnable {
    private String title;
    private String message;
    private MessageType type;
    private Display display;

    public ShowMessage(String title, String message, MessageType type) {
        this.title = title;
        this.message = message;
        this.type = type;
        this.display = this.getDisplay();
        this.display.asyncExec((Runnable)this);
    }

    public ShowMessage(Display display, String title, String message, MessageType type) {
        this.title = title;
        this.message = message;
        this.type = type;
        this.display = display;
        display.asyncExec((Runnable)this);
    }

    public ShowMessage(String title, String message, MessageType type, boolean sync) {
        this.title = title;
        this.message = message;
        this.type = type;
        this.display = this.getDisplay();
        if (sync) {
            this.display.syncExec((Runnable)this);
        } else {
            this.display.asyncExec((Runnable)this);
        }
    }

    public ShowMessage(Display display, String title, String message, MessageType type, boolean sync) {
        this.title = title;
        this.message = message;
        this.type = type;
        this.display = display;
        if (sync) {
            display.syncExec((Runnable)this);
        } else {
            display.asyncExec((Runnable)this);
        }
    }

    public Display getDisplay() {
        if (this.display != null) {
            return this.display;
        }
        Display d = Display.getCurrent();
        if (d != null) {
            return d;
        }
        return Display.getDefault();
    }

    @Override
    public void run() {
        Shell shell = this.display.getActiveShell();
        if (this.type == MessageType.ERROR) {
            MessageDialog.openError((Shell)shell, (String)this.title, (String)this.message);
        }
        if (this.type == MessageType.CONFIRM) {
            MessageDialog.openConfirm((Shell)shell, (String)this.title, (String)this.message);
        }
        if (this.type == MessageType.INFORMATION) {
            MessageDialog.openInformation((Shell)shell, (String)this.title, (String)this.message);
        }
        if (this.type == MessageType.QUESTION) {
            MessageDialog.openQuestion((Shell)shell, (String)this.title, (String)this.message);
        }
        if (this.type == MessageType.WARNING) {
            MessageDialog.openWarning((Shell)shell, (String)this.title, (String)this.message);
        }
    }

    public static void showError(Display display, String title, String message) {
        new ShowMessage(display, title, message, MessageType.ERROR);
    }

    public static void showError(String title, String message) {
        new ShowMessage(title, message, MessageType.ERROR);
    }

    public static void showStatus(IStatus status) {
        MessageType type = MessageType.INFORMATION;
        String title = "";
        if (status.getSeverity() == 0) {
            type = MessageType.INFORMATION;
            title = "Status OK";
        }
        if (status.getSeverity() == 2) {
            type = MessageType.WARNING;
            title = "Status Warning";
        }
        if (status.getSeverity() == 4) {
            type = MessageType.ERROR;
            title = "Status Error";
        }
        if (status.getSeverity() == 8) {
            type = MessageType.INFORMATION;
            title = "Status Cancel";
        }
        if (status.getSeverity() == 1) {
            type = MessageType.INFORMATION;
            title = "Status Info";
        }
        new ShowMessage(title, status.getMessage(), type);
    }

    public static void showWarning(Display display, String title, String message) {
        new ShowMessage(display, title, message, MessageType.WARNING);
    }

    public static void showWarning(String title, String message) {
        new ShowMessage(title, message, MessageType.WARNING);
    }

    public static void showInformation(Display display, String title, String message) {
        new ShowMessage(display, title, message, MessageType.INFORMATION);
    }

    public static void showInformation(String title, String message) {
        new ShowMessage(title, message, MessageType.INFORMATION);
    }

    public static void syncShowError(Display display, String title, String message) {
        new ShowMessage(display, title, message, MessageType.ERROR, true);
    }

    public static void syncShowError(String title, String message) {
        new ShowMessage(title, message, MessageType.ERROR, true);
    }

    public static void syncShowWarning(Display display, String title, String message) {
        new ShowMessage(display, title, message, MessageType.WARNING, true);
    }

    public static void syncShowWarning(String title, String message) {
        new ShowMessage(title, message, MessageType.WARNING, true);
    }

    public static void syncShowInformation(Display display, String title, String message) {
        new ShowMessage(display, title, message, MessageType.INFORMATION, true);
    }

    public static void syncShowInformation(String title, String message) {
        new ShowMessage(title, message, MessageType.INFORMATION, true);
    }

    public static enum MessageType {
        ERROR,
        CONFIRM,
        INFORMATION,
        QUESTION,
        WARNING;

    }
}

