/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.utils;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;

public class GetConfigurationRequest
implements Read<Resource> {
    private Resource resource;

    public GetConfigurationRequest(Resource resource) {
        this.resource = resource;
    }

    public Resource perform(ReadGraph graph) throws DatabaseException {
        return this.getConfiguration(graph, this.resource);
    }

    private Resource getConfiguration(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource parent = graph.getPossibleObject(resource, L0.PartOf);
        if (parent == null) {
            return null;
        }
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(parent, SR.SysdynModel)) {
            parent = graph.getPossibleObject(parent, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration);
        }
        if (graph.isInstanceOf(parent, SR.Configuration)) {
            return parent;
        }
        return this.getConfiguration(graph, parent);
    }
}

