/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.rule.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.mapping.rule.instructions.IRuleInstruction;

public class QueryRuleInstruction
implements IRuleInstruction {
    IRuleInstruction rule;
    int[] variables;
    int workSpace;

    public QueryRuleInstruction(IRuleInstruction rule) {
        this.rule = rule;
        TIntHashSet reads = new TIntHashSet();
        TIntHashSet writes = new TIntHashSet();
        rule.collectVariables(reads, writes);
        reads.removeAll(writes.toArray());
        this.variables = reads.toArray();
        final TIntIntHashMap map = new TIntIntHashMap();
        int i = 0;
        while (i < this.variables.length) {
            map.put(this.variables[i], i);
            ++i;
        }
        this.workSpace = this.variables.length;
        writes.forEach(new TIntProcedure(){

            public boolean execute(int arg0) {
                map.put(arg0, QueryRuleInstruction.this.workSpace++);
                return true;
            }
        });
        rule.mapVariables(map);
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        reads.addAll(this.variables);
    }

    @Override
    public IModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
        Object[] parameters = new Object[this.variables.length];
        int i = 0;
        while (i < this.variables.length) {
            parameters[i] = bindings[this.variables[i]];
            ++i;
        }
        IModification result = (IModification)g.syncRequest((Read)new Query(parameters));
        return result;
    }

    @Override
    public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
        Object[] parameters = new Object[this.variables.length];
        int i = 0;
        while (i < this.variables.length) {
            parameters[i] = bindings[this.variables[i]];
            ++i;
        }
        IModification modi = (IModification)g.syncRequest((Read)new Query(parameters));
        if (modi != null) {
            modi.perform(g);
        }
    }

    @Override
    public void mapVariables(TIntIntHashMap map) {
        int i = 0;
        while (i < this.variables.length) {
            this.variables[i] = map.get(this.variables[i]);
            ++i;
        }
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        b.append("QUERY[");
        b.append(this.workSpace);
        b.append("]");
        int i = 0;
        while (i < this.variables.length) {
            b.append(" " + this.variables[i] + "->" + i);
            ++i;
        }
        b.append('\n');
        i = 0;
        while (i < indent) {
            b.append("     ");
            ++i;
        }
        this.rule.toString(b, indent);
    }

    class Query
    implements Read<IModification> {
        Object[] parameters;

        public Query(Object[] parameters) {
            this.parameters = parameters;
        }

        QueryRuleInstruction parent() {
            return QueryRuleInstruction.this;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            Query q = (Query)other;
            if (!this.parent().equals(q.parent())) {
                return false;
            }
            if (this.parameters.length != q.parameters.length) {
                return false;
            }
            int i = 0;
            while (i < this.parameters.length) {
                if (this.parameters[i] == null ? q.parameters[i] != null : !this.parameters[i].equals(q.parameters[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int hashCode() {
            int result = QueryRuleInstruction.this.hashCode();
            Object[] objectArray = this.parameters;
            int n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Object parameter = objectArray[n2];
                result *= 31;
                if (parameter != null) {
                    result += parameter.hashCode();
                } else {
                    System.err.println("Parameter is null!!!");
                }
                ++n2;
            }
            return result;
        }

        public IModification perform(ReadGraph g) throws DatabaseException {
            Object[] bindings = new Object[QueryRuleInstruction.this.workSpace];
            System.arraycopy(this.parameters, 0, bindings, 0, this.parameters.length);
            return QueryRuleInstruction.this.rule.execute(g, bindings);
        }
    }
}

