/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.utils;

import java.util.ArrayList;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;

public class SCLUtils {
    public static Resource getModel(ReadGraph graph, String modelName) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource model : SCLUtils.getModels(graph)) {
            if (!graph.getRelatedValue(model, l0.HasName, (Binding)Bindings.STRING).equals(modelName)) continue;
            return model;
        }
        throw new DatabaseException("Model " + modelName + " could not be found");
    }

    public static List<Resource> getModels(ReadGraph graph) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sys = SysdynResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> models = new ArrayList<Resource>();
        for (Resource child : graph.getObjects(Simantics.getProjectResource(), l0.ConsistsOf)) {
            if (!graph.isInstanceOf(child, sys.SysdynModel)) continue;
            models.add(child);
        }
        return models;
    }

    public static Resource getParameter(ReadGraph graph, Resource model, String parameterName) throws DatabaseException {
        for (Resource parameter : SCLUtils.getParameters(graph, model)) {
            if (!SCLUtils.getParameterName(graph, parameter).equals(parameterName)) continue;
            return parameter;
        }
        throw new DatabaseException("Parameter " + parameterName + " could not be found");
    }

    public static List<Resource> getParameters(ReadGraph graph, Resource model) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SimulationResource sim = SimulationResource.getInstance((ReadGraph)graph);
        SysdynResource sys = SysdynResource.getInstance((ReadGraph)graph);
        Resource configuration = graph.getSingleObject(model, sim.HasConfiguration);
        ArrayList<Resource> parameters = new ArrayList<Resource>();
        for (Resource child : graph.getObjects(configuration, l0.ConsistsOf)) {
            if (!graph.isInstanceOf(child, sys.IndependentVariable)) continue;
            Resource expressions = graph.getSingleObject(child, sys.Variable_expressionList);
            for (Resource expression : ListUtils.toList((ReadGraph)graph, (Resource)expressions)) {
                if (!graph.isInstanceOf(expression, sys.ParameterExpression)) continue;
                parameters.add(expression);
            }
        }
        return parameters;
    }

    public static String getParameterName(ReadGraph graph, Resource parameter) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sys = SysdynResource.getInstance((ReadGraph)graph);
        StringBuilder name = new StringBuilder();
        Resource variable = graph.getSingleObject(parameter, l0.PartOf);
        name.append((String)graph.getRelatedValue(variable, l0.HasName, (Binding)Bindings.STRING));
        String suffix = (String)graph.getPossibleRelatedValue(parameter, sys.Expression_arrayRange, (Binding)Bindings.STRING);
        if (suffix != null) {
            name.append(suffix);
        }
        return name.toString();
    }

    public static double getParameterValue(ReadGraph graph, Resource parameter) throws DatabaseException {
        SysdynResource sys = SysdynResource.getInstance((ReadGraph)graph);
        String str = (String)graph.getRelatedValue(parameter, sys.Expression_equation, (Binding)Bindings.STRING);
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static void setParameterValue(WriteGraph graph, Resource parameter, double value) throws DatabaseException {
        SysdynResource sys = SysdynResource.getInstance((ReadGraph)graph);
        String str = Double.toString(value);
        graph.claimLiteral(parameter, sys.Expression_equation, (Object)str, (Binding)Bindings.STRING);
    }
}

