/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.unitParser.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import org.simantics.sysdyn.unitParser.Token;
import org.simantics.sysdyn.unitParser.UnitCheckingException;
import org.simantics.sysdyn.unitParser.UnitCheckingNode;
import org.simantics.sysdyn.unitParser.nodes.Divide;
import org.simantics.sysdyn.unitParser.nodes.Multiplication;
import org.simantics.sysdyn.unitParser.nodes.UnitResult;
import org.simantics.sysdyn.utils.Function;

public class Term
extends UnitCheckingNode {
    public Term(int id) {
        super(id);
    }

    @Override
    public UnitResult getUnits(HashMap<String, String> units, ArrayList<Function> functions, boolean allowEquivalents) throws UnitCheckingException {
        UnitResult result = new UnitResult(allowEquivalents);
        UnitCheckingNode current = null;
        UnitCheckingNode operator = null;
        UnitCheckingNode base = null;
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            current = (UnitCheckingNode)this.jjtGetChild(i);
            UnitResult currentUnits = current.getUnits(units, functions, allowEquivalents);
            if (currentUnits.getUnitType() == UnitResult.UnitType.ANY) {
                result = new UnitResult(allowEquivalents);
                result.setUnitType(UnitResult.UnitType.ANY);
                return result;
            }
            if (currentUnits.getUnitType() != UnitResult.UnitType.OPERATOR) {
                if (base == null) {
                    base = current;
                    result.appendResult(currentUnits);
                } else {
                    UnitResult.UnitType unitType;
                    operator = (UnitCheckingNode)this.jjtGetChild(i - 1);
                    if (operator instanceof Multiplication) {
                        unitType = currentUnits.getUnitType();
                        if (unitType != UnitResult.UnitType.SCALAR && unitType != UnitResult.UnitType.DMNL) {
                            result.append(operator.printNode());
                            result.appendResult(currentUnits);
                        }
                    } else if (operator instanceof Divide) {
                        result.append(operator.printNode());
                        result.addAllDividents(currentUnits.getDividers());
                        result.addAllDividers(currentUnits.getDividents());
                        unitType = currentUnits.getUnitType();
                        if (unitType == UnitResult.UnitType.SCALAR || unitType == UnitResult.UnitType.DMNL) {
                            result.append("1");
                        } else {
                            result.append(currentUnits.getFullUnit());
                            result.setUnitType(unitType);
                        }
                    }
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public String printNode() {
        StringBuilder sb = new StringBuilder();
        Token token = this.jjtGetFirstToken();
        sb.append(token.image);
        Token prevToken = null;
        while (token != null && !token.equals(this.jjtGetLastToken())) {
            prevToken = token;
            token = token.next;
            if (!(token.image.equals("[") || token.image.equals("]") || prevToken.image.equals("[") || prevToken.image.equals("]") || token.image.equals(".") || prevToken.image.equals("."))) {
                sb.append(" ");
            }
            sb.append(token.image);
        }
        return sb.toString();
    }
}

