/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter.distribution;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.adapter.distribution.IDistribution;

public class Interval
implements IDistribution {
    private double min = 0.0;
    private double max = 10.0;
    private double intervalLength = 1.0;
    private int numberOfValues = 10;
    private int index = 0;

    public Interval(ReadGraph graph, Resource distribution) {
        try {
            Resource parameter;
            Resource experiment;
            Integer numberOfValues;
            Double maxValue;
            SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
            Double minValue = (Double)graph.getPossibleRelatedValue(distribution, SR.Interval_minValue, (Binding)Bindings.DOUBLE);
            if (minValue != null) {
                this.min = minValue;
            }
            if ((maxValue = (Double)graph.getPossibleRelatedValue(distribution, SR.Interval_maxValue, (Binding)Bindings.DOUBLE)) != null) {
                this.max = maxValue;
            }
            if ((numberOfValues = (Integer)graph.getPossibleRelatedValue(experiment = graph.getPossibleObject(parameter = graph.getPossibleObject(distribution, SR.SensitivityAnalysisExperiment_Parameter_propabilityDistribution_Inverse), Layer0.getInstance((ReadGraph)graph).PartOf), SR.SensitivityAnalysisExperiment_numberOfValues, (Binding)Bindings.INTEGER)) != null) {
                this.numberOfValues = numberOfValues;
            }
            this.intervalLength = (maxValue - minValue) / (double)(this.numberOfValues - 1);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public int getNumberOfValues() {
        return this.numberOfValues;
    }

    public double getIntervalLength() {
        return this.intervalLength;
    }

    @Override
    public double inverseCDF(double probability) {
        double value = this.min + this.intervalLength * (double)this.index;
        ++this.index;
        if (this.index >= this.numberOfValues) {
            this.index = 0;
        }
        return value;
    }
}

