/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui.test;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.simantics.spreadsheet.ui.test.RowHeaderRenderer;

public class RowHeaderExample
extends JFrame {
    public RowHeaderExample() {
        super("Row Header Example");
        this.setSize(300, 150);
        AbstractListModel lm = new AbstractListModel(){

            @Override
            public int getSize() {
                return 500;
            }

            @Override
            public Object getElementAt(int index) {
                return "" + index;
            }
        };
        DefaultTableModel dm = new DefaultTableModel(lm.getSize(), 500);
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 10) {
                dm.setValueAt(new Object(){
                    private Integer i = new Integer((int)(20.0 * Math.random()));
                }, i, j);
                ++j;
            }
            ++i;
        }
        dm.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
            }
        });
        JTable table = new JTable(dm);
        new ExcelAdapter(table);
        table.setAutoResizeMode(0);
        table.setColumnSelectionAllowed(true);
        table.addRowSelectionInterval(1, 3);
        table.addColumnSelectionInterval(1, 3);
        JList rowHeader = new JList(lm);
        rowHeader.setFixedCellWidth(50);
        rowHeader.setFixedCellHeight(table.getRowHeight());
        rowHeader.setCellRenderer(new RowHeaderRenderer(table));
        JScrollPane scroll = new JScrollPane(table);
        scroll.setRowHeaderView(rowHeader);
        this.getContentPane().add((Component)scroll, "Center");
    }

    public static void main(String[] args) {
        RowHeaderExample frame = new RowHeaderExample();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    public class ExcelAdapter
    implements ActionListener {
        private String rowstring;
        private String value;
        private Clipboard system;
        private StringSelection stsel;
        private JTable jTable1;

        public ExcelAdapter(JTable myJTable) {
            this.jTable1 = myJTable;
            KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
            KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
            this.jTable1.registerKeyboardAction(this, "Copy", copy, 0);
            this.jTable1.registerKeyboardAction(this, "Paste", paste, 0);
            this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
        }

        public JTable getJTable() {
            return this.jTable1;
        }

        public void setJTable(JTable jTable1) {
            this.jTable1 = jTable1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int j;
            if (e.getActionCommand().compareTo("Copy") == 0) {
                StringBuffer sbf = new StringBuffer();
                int numcols = this.jTable1.getSelectedColumnCount();
                int numrows = this.jTable1.getSelectedRowCount();
                int[] rowsselected = this.jTable1.getSelectedRows();
                int[] colsselected = this.jTable1.getSelectedColumns();
                if (numrows - 1 != rowsselected[rowsselected.length - 1] - rowsselected[0] || numrows != rowsselected.length || numcols - 1 != colsselected[colsselected.length - 1] - colsselected[0] || numcols != colsselected.length) {
                    JOptionPane.showMessageDialog(null, "Invalid Copy Selection", "Invalid Copy Selection", 0);
                    return;
                }
                int i = 0;
                while (i < numrows) {
                    j = 0;
                    while (j < numcols) {
                        sbf.append(this.jTable1.getValueAt(rowsselected[i], colsselected[j]));
                        if (j < numcols - 1) {
                            sbf.append("\t");
                        }
                        ++j;
                    }
                    sbf.append("\n");
                    ++i;
                }
                this.stsel = new StringSelection(sbf.toString());
                this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
                this.system.setContents(this.stsel, this.stsel);
            }
            if (e.getActionCommand().compareTo("Paste") == 0) {
                int startRow = this.jTable1.getSelectedRows()[0];
                int startCol = this.jTable1.getSelectedColumns()[0];
                try {
                    String trstring = (String)this.system.getContents(this).getTransferData(DataFlavor.stringFlavor);
                    StringTokenizer st1 = new StringTokenizer(trstring, "\n");
                    int i = 0;
                    while (st1.hasMoreTokens()) {
                        this.rowstring = st1.nextToken();
                        StringTokenizer st2 = new StringTokenizer(this.rowstring, "\t");
                        j = 0;
                        while (st2.hasMoreTokens()) {
                            this.value = st2.nextToken();
                            if (startRow + i < this.jTable1.getRowCount() && startCol + j < this.jTable1.getColumnCount()) {
                                this.jTable1.setValueAt(this.value, startRow + i, startCol + j);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

