/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.tests;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

import junit.framework.TestCase;

import org.simantics.databoard.util.binary.BinaryFile;

public class testFileUtil extends TestCase {

	
	public void testInsertRemove()
	throws IOException
	{
		File tmp1 = File.createTempFile("tmp", "tmp");
		tmp1.deleteOnExit();
		
		RandomAccessFile file = new RandomAccessFile(tmp1, "rw");
		
		// Write 4 MB file
		BinaryFile write = new BinaryFile(file);
		for (int i=0; i<1024*1024; i++)
		{
			write.writeInt(i ^0x53);
		}
		write.flush();
		write.close();

		int iterCount = 16;
		long totInsertTime = 0;
		long totRemoveTime = 0;
		
		for (int iter=0; iter<iterCount; iter++) {
		// Verify content
		// 1. half
		file = new RandomAccessFile(tmp1, "rw");
		BinaryFile read = new BinaryFile(file);		
		read.position(0);
		for (int i=0; i<1024*1024; i++)
			assertEquals(i^0x53, read.readInt());
		read.close();
		file.close();
		
		// Add 256 kb at 2MB
		System.gc();
		long startTime = System.currentTimeMillis();
		file = new RandomAccessFile(tmp1, "rw");
		BinaryFile.insertBytes(file, 512*1024*4, 256*1024);
		long elapsedTime = System.currentTimeMillis() - startTime;
		totInsertTime += elapsedTime;
		System.out.println("Insert 256kb in front of 2MB, time: "+elapsedTime);
		
		// Verify file size
		assertEquals(4*1024*1024 + 256*1024, file.length());
		
		// Verify content
		// 1. half
		read = new BinaryFile(file);		
		read.position(0);
		for (int i=0; i<512*1024; i++)
			assertEquals(i^0x53, read.readInt());
		// 2. half
		read.position(512*1024*4+256*1024);
		for (int i=512*1024; i<1024*1024; i++)
			assertEquals(i^0x53, read.readInt());
		read.close();
		file.close();

		// Remove content
		file = new RandomAccessFile(tmp1, "rw");
		System.gc();
		startTime = System.currentTimeMillis();
		BinaryFile.removeBytes(file, 512*1024*4, 256*1024);
		elapsedTime = System.currentTimeMillis() - startTime;
		totRemoveTime += elapsedTime;
		System.out.println("remove 256kb in front of 2,25MB, time: "+elapsedTime);
		
		// Verify file size
		assertEquals(4*1024*1024, file.length());
		
		// Verify content
		// 1. half
		read = new BinaryFile(file);		
		read.position(0);
		for (int i=0; i<1024*1024; i++)
			assertEquals(i^0x53, read.readInt());
		read.close();		
		}

		System.out.println("Average insert time: " + totInsertTime / iterCount);
		System.out.println("Average remove time: " + totRemoveTime / iterCount);
		
		tmp1.delete();
	}
	
	
}

