/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import org.simantics.databoard.annotations.Identifier;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.util.Bean;

public class BeanExample {

	public static class MyBean extends Bean {
		public String name;
		public List<Integer> values;
	}

	public static class MyBean2 extends Bean.Id {
		public @Identifier String name;
		public List<Integer> values;
	}
	
	public static void main(String[] args) throws IOException, DataTypeSyntaxError {
		
		// Init
		MyBean bean = new MyBean();
		bean.init();
		bean.name = "MyBean";
		bean.values.add(5);
		bean.values.add(4);
		bean.values.add(2);
		bean.values.add(1);
		bean.values.add(0);

		// toString
		System.out.println( "toString()");
		System.out.println( "  Bean = " + bean );
		System.out.println( "" );
		
		// Serialization
		System.out.println( "Serialization" );
		byte[] data = bean.serialize();
		MyBean bean2 = new MyBean();
		bean2.deserialize( data );
		System.out.println( "  Serialize(Bean) = " + Arrays.toString(data) );
		System.out.println( "  Deserialize(data) = " + bean2 );
		System.out.println( "" );
		
		// JSON
		System.out.println("JSON");
		String json = bean.print();
		System.out.println( "  JSON(Bean3) = " + json);
		MyBean bean3 = new MyBean();
		bean3.parse( json );
		System.out.println( "  Parse(json) = " + bean3 );
		System.out.println( "" );
		
		// Hash-Equals
		System.out.println( "Hash-Equals" );
		System.out.println( "  hashCode(Bean) = " + bean.hashCode() );
		System.out.println( "  hashCode(Bean2) = " + bean2.hashCode() );
		System.out.println( "  equals(Bean, Bean2) = " + bean.equals(bean2) );
		System.out.println( "" );
		
		// Comparator
		System.out.println( "Compare");
		System.out.println( "  compare(Bean, Bean2) = " + bean.compareTo(bean2) );
		System.out.println( "" );
		
		// Clone
		MyBean bean4 = (MyBean) bean.clone();
		System.out.println( "Clone" );
		System.out.println( "  Bean4 = Bean.Clone()" );
		System.out.println( "  Bean4 = "+bean4 );
		System.out.println( "" );
		
		// ReadFrom
		System.out.println( "ReadFrom");		
		System.out.println( "  Bean.Name = \""+bean.name+"\"");
		bean4.name = "New Name";
		System.out.println( "  Bean4.Name <-- \""+bean4.name+"\"");
		System.out.println( "  Bean.readFrom(Bean4)");
		bean.readFrom( bean4 );
		System.out.println( "  Bean.Name = \""+bean.name+"\"");
		
		
	}
	
}
