# Basic functions and operators

## Booleans

::data[Builtin/Boolean]
::value[&&, ||, not, and, or, all, any, otherwise]

## Comparison

::class[Eq, Ord]
::value[minimum, maximum, minimumBy, maximumBy, &<&]

## Numeric functions

::data[Builtin/Short, Builtin/Integer, Builtin/Long, Builtin/Float, Builtin/Double]
::class[Additive, Ring, OrderedRing, Real, Integral]

# Data structures

## Tuples

::value[fst, snd, curry, uncurry, curry3, uncurry3]

## Maybe

::data[Builtin/Maybe]
::value[fromJust, fromMaybe, execJust, filterJust, orElse, elemMaybe]

## Either

::data[Either]
::value[mapEither]

## Lists

::class[Sequence]
::value[!, getList]
::value[elem]
::value[filter, concatMap]
::value[foldl, foldl1, foldr]
::value[unfoldl, unfoldr]
::value[zip, zipWith, unzip]
::value[sort, sortBy, sortWith]
::value[index, indexBy, indexWith]
::value[unique, uniqueBy]
::value[tail, reverse, range, \\, deleteAllBy, for, lookup, addList]
::value[groupBy, intersect, findFirst]
::value[singletonList]
::value[group, groupWith]
::value[mapFirst, mapMaybe]
::value[build]
::value[uniqueWith]

## Strings

::value[trim, splitString, indexOf, lastIndexOf, startsWith, endsWith, regionMatches, replaceString]
::value[contains]
::value[charAt]
::value[isLetter, addChar, subChar]
::value[string]
::value[joinWithSeparator]
::value[printWithSeparator]

# Higher order programming

## Functions

::value[const, $, ., id, flip, ignore]

## Functors

::class[Functor, FunctorE]

## Monads

::class[Monad]
::value[>>]
::class[FunctorM]
::value[repeatForever]
::class[MonadZero]
::value[guard]
::class[MonadPlus, MonadOr]
::value[ignoreM]

# Side-effects 

## Mutable references

::data[Ref]
::value[ref, getRef, :=]

## Failure

::value[Builtin/fail]

## Control structures

::value[while,forN]

## Console

::value[print, printString, printError, printErrorsAsNormalPrints, printingToFile]

## Progress

::value[didWork, checkInterrupted, isInterrupted]

## UIDs

::value[generateUID]

# Data

## String conversion

::class[Show]
::value[<<]
::data[Par]
::class[Read]
::value[toLowerCase, toUpperCase]

## Other conversions

::value[toDoubleArray, fromDoubleArray, arrayToList]

## Hashing

::class[Hashable]
::value[hash]

## Serialization

::data[Builtin/Binding]
::class[Builtin/Serializable]
::value[Builtin/binding]
::value[serialize, deserialize]

## Typeable

::data[Builtin/Type]
::class[Builtin/Typeable]
::value[Builtin/typeOf]

## Dynamic

::data[Dynamic]
::value[toDynamic, fromDynamic]

# Undocumented entities

::undocumented[]