/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.Text;
import com.kitfox.svg.Tspan;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.simantics.scenegraph.ExportableWidget;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.LoaderNode;
import org.simantics.scenegraph.ScenegraphUtils;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.g2d.nodes.SVGNodeAssignment;
import org.simantics.scenegraph.utils.BufferedImage;
import org.simantics.scenegraph.utils.G2DUtils;
import org.simantics.scenegraph.utils.InitValueSupport;
import org.simantics.scenegraph.utils.MipMapBufferedImage;
import org.simantics.scenegraph.utils.MipMapVRamBufferedImage;
import org.simantics.scenegraph.utils.SVGPassthruShape;
import org.simantics.scenegraph.utils.VRamBufferedImage;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.utils.threads.AWTThread;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@ExportableWidget.RasterOutputWidget
public class SVGNode
extends G2DNode
implements InitValueSupport,
LoaderNode {
    private static final long serialVersionUID = 8508750881358776559L;
    protected String data = null;
    protected String defaultData = null;
    protected Point targetSize = null;
    protected Boolean useMipMap = true;
    protected Rectangle2D bounds = null;
    protected List<SVGNodeAssignment> assignments = new ArrayList<SVGNodeAssignment>();
    protected transient BufferedImage buffer = null;
    protected transient String documentCache = null;
    protected transient SVGDiagram diagramCache = null;
    protected transient String dataHash = null;
    static transient Map<String, WeakReference<BufferedImage>> bufferCache = new HashMap<String, WeakReference<BufferedImage>>();
    static WeakHashMap<String, String> dataCache = new WeakHashMap();
    private static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    static WeakHashMap<String, String> digestCache;
    static URL BROKEN_SVG_DATA;
    static URL EMPTY_SVG_DATA;

    static {
        dbf.setValidating(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/namespaces", false);
            dbf.setFeature("http://xml.org/sax/features/validation", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        digestCache = new WeakHashMap();
        BROKEN_SVG_DATA = SVGNode.class.getResource("broken.svg");
        EMPTY_SVG_DATA = SVGNode.class.getResource("empty.svg");
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void cleanup() {
        this.cleanDiagramCache();
    }

    public void setAssignments(List<SVGNodeAssignment> ass) {
        this.assignments.clear();
        this.assignments.addAll(ass);
    }

    public void cleanDiagramCache() {
        SVGDiagram d = this.diagramCache;
        if (d != null) {
            this.diagramCache = null;
            SVGUniverse univ = SVGCache.getSVGUniverse();
            univ.decRefCountAndClear(d.getXMLBase());
        }
    }

    @INode.PropertySetter(value="SVG")
    @INode.SyncField(value={"data"})
    public void setData(String data) {
        String cached = dataCache.get(data);
        if (cached == null) {
            cached = data;
            dataCache.put(data, data);
        }
        this.data = cached;
        this.defaultData = cached;
        this.cleanDiagramCache();
    }

    @INode.SyncField(value={"targetSize"})
    public void setTargetSize(Point p) {
        this.targetSize = p;
    }

    @INode.SyncField(value={"targetSize"})
    public void setTargetSize(int x, int y) {
        this.targetSize = new Point(x, y);
    }

    @INode.SyncField(value={"useMipMap"})
    public void useMipMap(Boolean use) {
        this.useMipMap = use;
    }

    @INode.PropertySetter(value="Bounds")
    @INode.SyncField(value={"bounds"})
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        if (this.bounds == null) {
            this.parseSVG();
        }
        return this.bounds;
    }

    @Override
    public void render(Graphics2D g2d) {
        if (this.data == null) {
            return;
        }
        AffineTransform ot = null;
        if (!this.transform.isIdentity()) {
            ot = g2d.getTransform();
            g2d.transform(this.transform);
        }
        if (g2d.getRenderingHint(G2DRenderingHints.KEY_SVG_PASSTHRU) == Boolean.TRUE) {
            String svg;
            SVGPassthruShape.resetG2D(g2d);
            String string = svg = this.assignments.isEmpty() ? this.data : SVGNode.applyAssigments(this.data, this.assignments);
            if (svg != null) {
                g2d.fill(new SVGPassthruShape(svg));
            }
        } else {
            if (!this.data.equals(this.documentCache) || this.diagramCache == null || this.buffer == null) {
                this.initBuffer(g2d);
            }
            if (this.buffer != null) {
                this.buffer.paint(g2d);
            }
        }
        if (ot != null) {
            g2d.setTransform(ot);
        }
    }

    protected int dynamicHash() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String parseSVG() {
        if (this.data == null) {
            return null;
        }
        SVGUniverse univ = SVGCache.getSVGUniverse();
        try {
            Rectangle2D bbox = null;
            SVGUniverse sVGUniverse = univ;
            synchronized (sVGUniverse) {
                if (this.diagramCache != null) {
                    univ.decRefCount(this.diagramCache.getXMLBase());
                    this.diagramCache = null;
                }
                SVGNodeAssignment rootAssignment = null;
                if (!this.assignments.isEmpty()) {
                    for (SVGNodeAssignment ass : this.assignments) {
                        if (!ass.attributeNameOrId.equals("$root")) continue;
                        rootAssignment = ass;
                        break;
                    }
                }
                byte[] dataBytes = rootAssignment != null ? rootAssignment.value.getBytes("UTF-8") : this.data.getBytes("UTF-8");
                this.dataHash = SVGNode.digest(dataBytes, this.assignments, this.dynamicHash());
                URI uri = univ.loadSVG((InputStream)new ByteArrayInputStream(dataBytes), this.dataHash);
                this.diagramCache = univ.getDiagram(uri, false);
                if (this.diagramCache != null) {
                    univ.incRefCount(this.diagramCache.getXMLBase());
                    SVGRoot root = this.diagramCache.getRoot();
                    if (root == null) {
                        univ.decRefCount(this.diagramCache.getXMLBase());
                        this.diagramCache = univ.getDiagram(univ.loadSVG(BROKEN_SVG_DATA), false);
                        this.dataHash = "broken";
                        univ.incRefCount(this.diagramCache.getXMLBase());
                        bbox = (Rectangle2D)this.diagramCache.getRoot().getBoundingBox().clone();
                    } else {
                        bbox = root.getBoundingBox();
                        if (bbox.isEmpty()) {
                            Set presentationAttributes = root.getPresentationAttributes();
                            if (!presentationAttributes.contains("display")) {
                                univ.decRefCount(this.diagramCache.getXMLBase());
                                this.diagramCache = univ.getDiagram(univ.loadSVG(EMPTY_SVG_DATA), false);
                                this.dataHash = "empty";
                                univ.incRefCount(this.diagramCache.getXMLBase());
                                bbox = (Rectangle2D)root.getBoundingBox().clone();
                            } else {
                                bbox = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                            }
                        } else {
                            bbox = this.applyAssignments(this.diagramCache, this.assignments) ? (Rectangle2D)root.getBoundingBox().clone() : (Rectangle2D)bbox.clone();
                        }
                    }
                } else {
                    bbox = new Rectangle2D.Double();
                }
            }
            this.documentCache = this.data;
            this.setBounds(bbox);
        }
        catch (SVGException sVGException) {
            this.setBounds(this.diagramCache.getViewRect((Rectangle2D)new Rectangle2D.Double()));
            univ.decRefCount(this.diagramCache.getXMLBase());
            this.diagramCache = null;
        }
        catch (IOException iOException) {
            this.diagramCache = null;
        }
        return this.dataHash;
    }

    protected static String applyAssigments(String svg, List<SVGNodeAssignment> assignments) {
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(svg)));
            NodeList entries = doc.getElementsByTagName("*");
            int i = 0;
            while (i < entries.getLength()) {
                Element element = (Element)entries.item(i);
                if (element.hasAttribute("id")) {
                    element.setIdAttribute("id", true);
                }
                ++i;
            }
            for (SVGNodeAssignment ass : assignments) {
                Element e = doc.getElementById(ass.elementId);
                if (e != null) {
                    if ("$text".equals(ass.attributeNameOrId)) {
                        if (!e.getTagName().equals("tspan")) continue;
                        if (ass.value.trim().isEmpty()) {
                            e.setTextContent("-");
                            continue;
                        }
                        e.setTextContent(ass.value);
                        continue;
                    }
                    if (ass.attributeNameOrId.startsWith("#")) {
                        e.setAttribute(ass.attributeNameOrId.substring(1), ass.value);
                        continue;
                    }
                    e.setAttribute(ass.attributeNameOrId, ass.value);
                    continue;
                }
                System.err.println("Element with id='" + ass.elementId + " was not found.");
            }
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean applyAssignments(SVGDiagram diagram, List<SVGNodeAssignment> assignments) throws SVGException {
        if (assignments.isEmpty()) {
            return false;
        }
        boolean changed = false;
        diagram.updateTime(0.0);
        for (SVGNodeAssignment ass : assignments) {
            SVGElement e = diagram.getElement(ass.elementId);
            if (e == null) continue;
            if ("$text".equals(ass.attributeNameOrId)) {
                if (!(e instanceof Tspan)) continue;
                Tspan t = (Tspan)e;
                if (ass.value.trim().isEmpty()) {
                    t.setText("-");
                } else {
                    t.setText(ass.value);
                }
                SVGElement parent = t.getParent();
                if (parent instanceof Text) {
                    ((Text)parent).rebuild();
                }
                changed = true;
                continue;
            }
            if (ass.attributeNameOrId.startsWith("#")) {
                e.setAttribute(ass.attributeNameOrId.substring(1), 0, ass.value);
                changed = true;
                continue;
            }
            e.setAttribute(ass.attributeNameOrId, 2, ass.value);
            changed = true;
        }
        diagram.updateTime(0.0);
        return changed;
    }

    public static Rectangle2D getBounds(String data) {
        return SVGNode.getBounds(data, 0);
    }

    public static Rectangle2D getBounds(String data, int dynamicHash) {
        return SVGNode.getBounds(data, Collections.emptyList(), dynamicHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle2D getBounds(String data, List<SVGNodeAssignment> assignments, int dynamicHash) {
        if (data == null) {
            new Exception("null SVG data").printStackTrace();
            return null;
        }
        SVGDiagram diagramCache = null;
        try {
            SVGUniverse univ;
            byte[] dataBytes = data.getBytes("UTF-8");
            String digest = SVGNode.digest(dataBytes, assignments, dynamicHash);
            SVGUniverse sVGUniverse = univ = SVGCache.getSVGUniverse();
            synchronized (sVGUniverse) {
                URI uri = univ.loadSVG((InputStream)new ByteArrayInputStream(dataBytes), digest);
                diagramCache = univ.getDiagram(uri, false);
                if (diagramCache != null) {
                    if (diagramCache.getRoot() == null) {
                        diagramCache = univ.getDiagram(univ.loadSVG(BROKEN_SVG_DATA));
                    } else if (diagramCache.getRoot().getBoundingBox().isEmpty()) {
                        diagramCache = univ.getDiagram(univ.loadSVG(EMPTY_SVG_DATA));
                    }
                }
            }
            Rectangle2D rect = null;
            if (diagramCache != null) {
                SVGRoot root = diagramCache.getRoot();
                Rectangle2D bbox = root.getBoundingBox();
                rect = (Rectangle2D)bbox.clone();
            } else {
                rect = new Rectangle2D.Double();
            }
            return rect;
        }
        catch (SVGException sVGException) {
            return diagramCache.getViewRect((Rectangle2D)new Rectangle2D.Double());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Rectangle2D getRealBounds(String data) {
        return SVGNode.getRealBounds(data, Collections.emptyList(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle2D getRealBounds(String data, List<SVGNodeAssignment> assignments, int dynamicHash) {
        if (data == null) {
            new Exception("null SVG data").printStackTrace();
            return null;
        }
        SVGDiagram diagramCache = null;
        try {
            SVGUniverse univ;
            byte[] dataBytes = data.getBytes("UTF-8");
            String digest = SVGNode.digest(dataBytes, assignments, dynamicHash);
            SVGUniverse sVGUniverse = univ = SVGCache.getSVGUniverse();
            synchronized (sVGUniverse) {
                URI uri = univ.loadSVG((InputStream)new ByteArrayInputStream(dataBytes), digest);
                diagramCache = univ.getDiagram(uri, false);
                if (diagramCache != null) {
                    SVGRoot root = diagramCache.getRoot();
                    if (root == null) {
                        return new Rectangle2D.Double();
                    }
                    return (Rectangle2D)root.getBoundingBox().clone();
                }
            }
        }
        catch (SVGException sVGException) {
            return diagramCache.getViewRect((Rectangle2D)new Rectangle2D.Double());
        }
        catch (IOException iOException) {}
        return null;
    }

    protected void initBuffer(Graphics2D g2d) {
        if (!this.data.equals(this.documentCache) || this.diagramCache == null) {
            this.dataHash = this.parseSVG();
            if (this.diagramCache == null) {
                System.err.println("UNABLE TO PARSE SVG:\n" + this.data);
                return;
            }
        }
        if (this.buffer != null) {
            this.buffer = null;
        }
        this.diagramCache.setIgnoringClipHeuristic(true);
        if (bufferCache.containsKey(this.dataHash) && bufferCache.get(this.dataHash).get() != null) {
            this.buffer = (BufferedImage)bufferCache.get(this.dataHash).get();
        } else if (this.diagramCache.getViewRect().getWidth() == 0.0 || this.diagramCache.getViewRect().getHeight() == 0.0) {
            this.buffer = null;
        } else if (this.useMipMap.booleanValue()) {
            this.buffer = G2DUtils.isAccelerated(g2d) ? new MipMapVRamBufferedImage(this.diagramCache, this.bounds, this.targetSize) : new MipMapBufferedImage(this.diagramCache, this.bounds, this.targetSize);
            bufferCache.put(this.dataHash, new WeakReference<BufferedImage>(this.buffer));
        } else {
            this.buffer = G2DUtils.isAccelerated(g2d) ? new VRamBufferedImage(this.diagramCache, this.bounds, this.targetSize) : new BufferedImage(this.diagramCache, this.bounds, this.targetSize);
            bufferCache.put(this.dataHash, new WeakReference<BufferedImage>(this.buffer));
        }
    }

    public void setProperty(String field, Object value) {
        if ("data".equals(field)) {
            this.data = (String)value;
        } else if ("z".equals(field)) {
            this.setZIndex((Integer)value);
        } else if ("position".equals(field)) {
            Point point = (Point)value;
            this.setTransform(AffineTransform.getTranslateInstance(point.x, point.y));
        }
    }

    @Override
    public void initValues() {
        this.data = this.defaultData;
        this.dataHash = null;
        this.buffer = null;
    }

    static String digest(byte[] dataBytes, List<SVGNodeAssignment> assignments, int dynamicHash) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(dataBytes);
            BigInteger number = new BigInteger(1, messageDigest);
            String dataHash = String.valueOf(number.toString(16)) + (assignments != null ? assignments.hashCode() : 0) + 31 * dynamicHash;
            String result = digestCache.get(dataHash);
            if (result == null) {
                result = dataHash;
                digestCache.put(dataHash, dataHash);
            }
            return result;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("MD5 digest must exist.");
        }
    }

    @Override
    public Function1<Object, Boolean> getPropertyFunction(String propertyName) {
        return ScenegraphUtils.getMethodPropertyFunction(AWTThread.getThreadAccess(), this, propertyName);
    }

    @Override
    public <T> T getProperty(String propertyName) {
        return null;
    }

    @Override
    public void setPropertyCallback(Function2<String, Object, Boolean> callback) {
    }

    public void synchronizeDocument(String document) {
        this.setData(document);
    }

    public void synchronizeTransform(double[] data) {
        this.setTransform(new AffineTransform(data));
    }

    public String getSVGText() {
        String ret = this.data.replace("<svg", "<g").replaceAll("svg>", "g>");
        return ret;
    }

    public Rectangle2D getElementBounds(String id) throws SVGException {
        SVGElement e = this.diagramCache.getElement(id);
        if (e instanceof RenderableElement) {
            return ((RenderableElement)e).getBoundingBox();
        }
        return null;
    }
}

