/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.svg.export;

import java.awt.Point;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.batik.svggen.SVGGraphics2D;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.export.ImagePrinter;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.svg.export.SVGBuilder;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.StructuralVariables;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.threads.WorkerThread;

public class DiagramToSVG {
    public static String diagramToSVG(Resource diagram) {
        try {
            ImagePrinter.ImageExportPlan exportPlan = new ImagePrinter.ImageExportPlan();
            exportPlan.margin = 0.05;
            exportPlan.dpi = 96.0;
            exportPlan.diagram = diagram;
            return DiagramToSVG.render(diagram, exportPlan);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<b>error</b> " + e.getMessage();
        }
    }

    public static String diagramToSVG(Resource diagram, int width, int height) {
        try {
            ImagePrinter.ImageExportPlan exportPlan = new ImagePrinter.ImageExportPlan();
            exportPlan.margin = 0.05;
            exportPlan.size = new Point(width, height);
            exportPlan.diagram = diagram;
            return DiagramToSVG.render(diagram, exportPlan);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<b>error</b> " + e.getMessage();
        }
    }

    public static String diagramToSVG(Resource diagram, double dpi) {
        try {
            ImagePrinter.ImageExportPlan exportPlan = new ImagePrinter.ImageExportPlan();
            exportPlan.margin = 0.05;
            exportPlan.dpi = dpi;
            exportPlan.diagram = diagram;
            return DiagramToSVG.render(diagram, exportPlan);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<b>error</b> " + e.getMessage();
        }
    }

    public static String diagramToSVG(Resource diagram, ImagePrinter.ImageExportPlan exportPlan, MarginUtils.Margins margins, SVGGraphics2D svgGenerator) {
        try {
            return DiagramToSVG.render(diagram, exportPlan, margins, svgGenerator);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<b>error</b> " + e.getMessage();
        }
    }

    private static String render(Resource input, ImagePrinter.ImageExportPlan exportPlan) throws Exception {
        return DiagramToSVG.render(input, exportPlan, null, SVGBuilder.defaultSVGGenerator());
    }

    private static String render(final Resource input, final ImagePrinter.ImageExportPlan exportPlan, final MarginUtils.Margins margins, final SVGGraphics2D svgExporter) throws Exception {
        Resource diagram = (Resource)Simantics.getSession().syncRequest((Read)new Read<Resource>(){

            public Resource perform(ReadGraph graph) throws DatabaseException {
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(input, DIA.Diagram)) {
                    return input;
                }
                StructuralResource2 SR = StructuralResource2.getInstance((ReadGraph)graph);
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(input, SR.Composite)) {
                    Resource possibleDiagram = graph.getPossibleObject(input, MOD.CompositeToDiagram);
                    if (possibleDiagram != null) {
                        return possibleDiagram;
                    }
                    for (Resource r : graph.getObjects(input, L0.ConsistsOf)) {
                        if (!graph.isInstanceOf(r, SR.Composite) || (possibleDiagram = graph.getPossibleObject(input, MOD.CompositeToDiagram)) == null) continue;
                        return possibleDiagram;
                    }
                }
                return null;
            }
        });
        if (diagram == null) {
            throw new DatabaseException("Input " + input + " cannot be resolved as diagram");
        }
        final WorkerThread thread = new WorkerThread("Diagram Image Painter");
        thread.start();
        final CanvasContext ctx = new CanvasContext((IThreadWorkQueue)thread);
        ctx.getDefaultHintContext().setHint(Hints.KEY_DISABLE_GRAPH_MODIFICATIONS, (Object)Boolean.TRUE);
        final AtomicReference sgProvider = new AtomicReference();
        final ISessionContext sessionContext = Simantics.getSessionContext();
        final DataContainer result = new DataContainer(null);
        final DataContainer exception = new DataContainer(null);
        try {
            final Semaphore done = new Semaphore(0);
            ThreadUtils.getBlockingWorkExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            Pair modelAndRVI = (Pair)sessionContext.getSession().syncRequest((Read)new UniqueRead<Pair<Resource, String>>(){

                                public Pair<Resource, String> perform(ReadGraph graph) throws DatabaseException {
                                    return new Pair((Object)DiagramToSVG.resolveModel(graph, exportPlan.diagram), (Object)DiagramToSVG.resolveRVI(graph, exportPlan.diagram));
                                }
                            });
                            ICanvasSceneGraphProvider provider = DiagramNodeUtil.loadSceneGraphProvider((ICanvasContext)ctx, (Resource)((Resource)modelAndRVI.first), (Resource)exportPlan.diagram, (String)((String)modelAndRVI.second));
                            sgProvider.set(provider);
                            ThreadUtils.asyncExec((IThreadWorkQueue)thread, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        try {
                                            SVGBuilder chassis = margins != null ? new SVGBuilder(exportPlan.dpi, exportPlan.size, margins) : new SVGBuilder(exportPlan.dpi, exportPlan.size, exportPlan.margin);
                                            result.set((Object)chassis.paint((ICanvasContext)ctx, svgExporter));
                                        }
                                        catch (Exception e) {
                                            exception.set((Object)e);
                                            done.release();
                                        }
                                    }
                                    finally {
                                        done.release();
                                    }
                                }
                            });
                        }
                        catch (DatabaseException e) {
                            exception.set((Object)e);
                            done.release();
                            done.release();
                        }
                        catch (Throwable e) {
                            exception.set((Object)new DatabaseException(e));
                            done.release();
                            done.release();
                        }
                    }
                    finally {
                        done.release();
                    }
                }
            });
            done.acquire(2);
            if (exception.get() != null) {
                throw (Exception)exception.get();
            }
            String string = (String)result.get();
            return string;
        }
        finally {
            if (sgProvider.get() != null) {
                ((ICanvasSceneGraphProvider)sgProvider.get()).dispose();
            }
            ctx.dispose();
        }
    }

    private static Resource resolveModel(ReadGraph graph, Resource diagram) throws DatabaseException {
        ModelingResources mod = ModelingResources.getInstance((ReadGraph)graph);
        Resource composite = graph.getSingleObject(diagram, mod.DiagramToComposite);
        Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(composite));
        if (model == null) {
            throw new ValidationException("no model found for composite " + NameUtils.getSafeName((ReadGraph)graph, (Resource)composite));
        }
        return model;
    }

    private static String resolveRVI(ReadGraph graph, Resource diagram) throws DatabaseException {
        ModelingResources mod = ModelingResources.getInstance((ReadGraph)graph);
        Resource composite = graph.getSingleObject(diagram, mod.DiagramToComposite);
        ResourceArray compositePath = StructuralVariables.getCompositeArray((ReadGraph)graph, (Resource)composite);
        ResourceArray variablePath = compositePath.removeFromBeginning(1);
        return StructuralVariables.getRVI((ReadGraph)graph, (ResourceArray)variablePath);
    }

    public static String renderWithLoader(Resource input, final ImagePrinter.ImageExportPlan exportPlan, final MarginUtils.Margins margins, final SVGGraphics2D svgExporter, IThreadWorkQueue loaderThread, IThreadWorkQueue painterThread) throws Exception {
        DataContainer exception;
        DataContainer result;
        block11: {
            CanvasContext ctx;
            block12: {
                if (!painterThread.currentThreadAccess()) {
                    throw new IllegalStateException("The callable should be called from the contextThread");
                }
                ctx = new CanvasContext(loaderThread);
                ctx.getDefaultHintContext().setHint(Hints.KEY_DISABLE_GRAPH_MODIFICATIONS, (Object)Boolean.TRUE);
                AtomicReference<ICanvasSceneGraphProvider> sgProvider = new AtomicReference<ICanvasSceneGraphProvider>();
                result = new DataContainer(null);
                exception = new DataContainer(null);
                try {
                    ISessionContext sessionContext = Simantics.getSessionContext();
                    Pair modelAndRVI = (Pair)sessionContext.getSession().syncRequest((Read)new UniqueRead<Pair<Resource, String>>(){

                        public Pair<Resource, String> perform(ReadGraph graph) throws DatabaseException {
                            return new Pair((Object)DiagramToSVG.resolveModel(graph, exportPlan.diagram), (Object)DiagramToSVG.resolveRVI(graph, exportPlan.diagram));
                        }
                    });
                    ICanvasSceneGraphProvider provider = DiagramNodeUtil.loadSceneGraphProvider((ICanvasContext)ctx, (Resource)((Resource)modelAndRVI.first), (Resource)exportPlan.diagram, (String)((String)modelAndRVI.second));
                    sgProvider.set(provider);
                    final Semaphore done = new Semaphore(0);
                    ThreadUtils.asyncExec((IThreadWorkQueue)loaderThread, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                try {
                                    SVGBuilder chassis = margins != null ? new SVGBuilder(exportPlan.dpi, exportPlan.size, margins) : new SVGBuilder(exportPlan.dpi, exportPlan.size, exportPlan.margin);
                                    result.set((Object)chassis.paint((ICanvasContext)ctx, svgExporter));
                                }
                                catch (DatabaseException e) {
                                    exception.set((Object)e);
                                    done.release();
                                    done.release();
                                }
                                catch (Throwable e) {
                                    exception.set((Object)new DatabaseException(e));
                                    done.release();
                                    done.release();
                                }
                            }
                            finally {
                                done.release();
                            }
                        }
                    });
                    done.acquire();
                }
                catch (DatabaseException e) {
                    exception.set((Object)e);
                    if (sgProvider.get() != null) {
                        ((ICanvasSceneGraphProvider)sgProvider.get()).dispose();
                    }
                    ctx.dispose();
                    break block11;
                }
                catch (Throwable e) {
                    try {
                        exception.set((Object)new DatabaseException(e));
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (sgProvider.get() != null) {
                            ((ICanvasSceneGraphProvider)sgProvider.get()).dispose();
                        }
                        ctx.dispose();
                    }
                }
                if (sgProvider.get() == null) break block12;
                ((ICanvasSceneGraphProvider)sgProvider.get()).dispose();
            }
            ctx.dispose();
        }
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        return (String)result.get();
    }
}

