/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ProxyChildVariable;
import org.simantics.db.layer0.variable.ProxySessionRequest;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;

public class ProxyVariables {
    public static Variable inputVariable(ReadGraph graph, Variable context) throws DatabaseException {
        Variable session = (Variable)graph.syncRequest((Read)new ProxySessionRequest(context));
        if (session == null) {
            return null;
        }
        String uri = (String)session.getPossiblePropertyValue(graph, "inputURI");
        if (uri == null) {
            return session;
        }
        return Variables.getVariable(graph, uri);
    }

    public static Variable sessionVariable(ReadGraph graph, Variable self) throws DatabaseException {
        return (Variable)graph.syncRequest((Read)new ProxySessionRequest(self));
    }

    public static Variable makeProxyVariable(ReadGraph graph, Variable base, Variable input) throws DatabaseException {
        base = base.getChild(graph, ">>>");
        String path = input.getURI(graph).substring("http:/".length());
        base = base.browse(graph, path);
        return base.getChild(graph, "<<<");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Variable proxySessionVariable(ReadGraph graph, Variable variable) throws DatabaseException {
        try {
            Variable child = variable.getParent(graph);
            Variable parent = child.getParent(graph);
            if (parent instanceof ProxyChildVariable) {
                Variable var = ((ProxyChildVariable)parent).other();
                if (var.getParent(graph) == null) {
                    return null;
                }
                return var;
            }
            Variable input = (Variable)parent.getPossiblePropertyValue(graph, "session");
            if (input == null) {
                System.out.println("null input for: " + parent.getURI(graph));
            }
            return input;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static Variable proxyVariableBase(ReadGraph graph, Variable variable) throws DatabaseException {
        Variable parent;
        block4: {
            try {
                parent = variable.getParent(graph);
                if (parent != null) break block4;
                return null;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
        if (parent instanceof ProxyChildVariable) {
            return ((ProxyChildVariable)parent).base();
        }
        return ProxyVariables.proxyVariableBase(graph, parent);
    }

    public static Variable proxyVariableInput(ReadGraph graph, Variable variable) throws DatabaseException {
        if (variable instanceof ProxyChildVariable) {
            Variable var = ((ProxyChildVariable)variable).other();
            if (var.getParent(graph) == null) {
                return null;
            }
            return var;
        }
        Variable parent = variable.getParent(graph);
        if (parent == null) {
            return null;
        }
        return ProxyVariables.proxyVariableBase(graph, parent);
    }

    public static Variable proxyVariableRoot(ReadGraph graph, Variable variable) throws DatabaseException {
        Variable parent;
        block4: {
            try {
                parent = variable.getParent(graph);
                if (parent != null) break block4;
                return null;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
        if (parent instanceof ProxyChildVariable) {
            return variable;
        }
        return ProxyVariables.proxyVariableRoot(graph, parent);
    }

    public static boolean isProxy(ReadGraph graph, Variable variable) throws DatabaseException {
        return ProxyVariables.proxyVariableRoot(graph, variable) != null;
    }
}

