/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.concurrent.TimeUnit;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.layer0.variable.NodeCache;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.simulator.variable.NodeManager;

public class NodeSupport<Node> {
    public final NodeManager<Node> manager;
    public final NodeCache<Node, Variant> valueCache;
    public final NodeCache<Node, Variables.NodeStructure> structureCache;

    public NodeSupport(NodeManager<Node> manager) {
        this(manager, 1L, TimeUnit.SECONDS);
    }

    public NodeSupport(NodeManager<Node> manager, long defaultExpirationTime, TimeUnit expirationTimeUnit) {
        if (manager == null) {
            throw new NullPointerException("null NodeManager");
        }
        long ns = expirationTimeUnit.toNanos(defaultExpirationTime);
        this.manager = manager;
        this.valueCache = new NodeCache(ns);
        this.structureCache = new NodeCache(ns);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.valueCache.hashCode();
        result = 31 * result + this.structureCache.hashCode();
        result = 31 * result + this.manager.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeSupport other = (NodeSupport)obj;
        return this.valueCache.equals(other.valueCache) && this.structureCache.equals(other.structureCache) && this.manager.equals(other.manager);
    }

    public void dispose() {
        this.valueCache.dispose();
        this.structureCache.dispose();
    }
}

