/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.Arrays;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.util.TGRepresentationUtils;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.utils.datastructures.hints.IHintContext;

public class TGSourceRepresentation
implements SimanticsClipboard.Representation {
    protected Resource[] resources;
    protected boolean ignoreVirtualResources = false;
    private TransferableGraphSource value = null;
    private TransferableGraphConfiguration2 configuration;

    public TGSourceRepresentation(Resource ... resources) {
        this.resources = resources;
    }

    public TGSourceRepresentation(boolean ignoreVirtualResources, Resource ... resources) {
        this.ignoreVirtualResources = ignoreVirtualResources;
        this.resources = resources;
    }

    public TGSourceRepresentation(TransferableGraphConfiguration2 configuration) {
        this.configuration = configuration;
    }

    public TGSourceRepresentation(TransferableGraphSource value) {
        this.value = value;
    }

    @Override
    public IHintContext.Key getKey() {
        return SimanticsKeys.KEY_TRANSFERABLE_GRAPH_SOURCE;
    }

    public TransferableGraphSource compute(ReadGraph graph, Map<String, Object> hints) throws DatabaseException {
        if (this.configuration == null) {
            this.configuration = new TransferableGraphConfiguration2(graph, Arrays.asList(this.resources), this.ignoreVirtualResources, false);
            this.configuration.exclusionFunction = TGRepresentationUtils.computeExclusionFunction(graph, this.resources, hints);
        }
        return (TransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(this.configuration));
    }

    @Override
    public <T> T getValue(RequestProcessor processor, final Map<String, Object> hints) throws DatabaseException {
        if (this.value == null) {
            this.value = (TransferableGraphSource)processor.syncRequest((Read)new UniqueRead<TransferableGraphSource>(){

                public TransferableGraphSource perform(ReadGraph graph) throws DatabaseException {
                    return TGSourceRepresentation.this.compute(graph, hints);
                }
            });
        }
        return (T)this.value;
    }
}

