/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ResourceMap;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.procedure.AsyncContextMultiProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

class ConsistsOfProcess {
    final List<InternalEntry> result;
    final Set<Resource> childrenWithNoName;
    final AsyncContextMultiProcedure<InternalEntry, Resource> structure;
    final AsyncContextMultiProcedure<InternalEntry, Resource> names;

    public static Pair<List<InternalEntry>, Set<Resource>> walk(ReadGraph graph, ResourceMap<SubgraphExtent.ExtentStatus> status, Collection<Resource> resources, Set<Resource> exclusions, boolean ignoreVirtual) throws DatabaseException {
        ConsistsOfProcess process = new ConsistsOfProcess(graph, status, resources, exclusions, ignoreVirtual);
        return Pair.make(process.result, process.childrenWithNoName);
    }

    private ConsistsOfProcess(ReadGraph graph, final ResourceMap<SubgraphExtent.ExtentStatus> status, final Collection<Resource> resources, final Set<Resource> exclusions, final boolean ignoreVirtual) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        final DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
        this.result = new ArrayList<InternalEntry>();
        this.childrenWithNoName = new HashSet<Resource>();
        this.names = dqs.compileForEachObject(graph, L0.HasName, (AsyncContextMultiProcedure)new AsyncContextMultiProcedure<InternalEntry, Resource>(){

            public void execute(AsyncReadGraph graph, final InternalEntry entry, Resource nameResource) {
                if (status != null) {
                    status.put((Object)nameResource, (Object)SubgraphExtent.ExtentStatus.EXCLUDED);
                }
                graph.forPossibleValue(nameResource, (Procedure)new Procedure<String>(){

                    public void execute(String name) {
                        if (!entry.valid) {
                            return;
                        }
                        if (name == null) {
                            entry.valid = false;
                        } else if (entry.name != null) {
                            entry.valid = false;
                        } else {
                            entry.name = name;
                        }
                    }

                    public void exception(Throwable t) {
                        Logger.defaultLogError((Throwable)t);
                    }
                });
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                Logger.defaultLogError((Throwable)throwable);
            }

            public void finished(AsyncReadGraph graph, InternalEntry entry) {
                if (entry.valid) {
                    if (entry.name != null) {
                        ConsistsOfProcess.this.result.add(entry);
                    } else {
                        ConsistsOfProcess.this.childrenWithNoName.add(entry.resource);
                    }
                } else {
                    ConsistsOfProcess.this.childrenWithNoName.add(entry.resource);
                }
            }
        });
        this.structure = dqs.compileForEachObject(graph, L0.ConsistsOf, (AsyncContextMultiProcedure)new AsyncContextMultiProcedure<InternalEntry, Resource>(){

            public void execute(AsyncReadGraph graph, InternalEntry parent, Resource child) {
                if (exclusions.contains(child)) {
                    return;
                }
                if (!ignoreVirtual || child.isPersistent()) {
                    InternalEntry entry = new InternalEntry(parent, child, null);
                    dqs.forEachObjectCompiled(graph, child, (Object)entry, ConsistsOfProcess.this.structure);
                    dqs.forEachObjectCompiled(graph, child, (Object)entry, ConsistsOfProcess.this.names);
                }
            }

            public void finished(AsyncReadGraph graph, InternalEntry parent) {
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                Logger.defaultLogError((Throwable)throwable);
            }
        });
        graph.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                for (Resource r : resources) {
                    InternalEntry root = new InternalEntry(null, r, null);
                    dqs.forEachObjectCompiled((AsyncReadGraph)graph, r, (Object)root, ConsistsOfProcess.this.structure);
                }
            }
        });
    }

    static class InternalEntry {
        public InternalEntry parent;
        public Resource resource;
        public String name;
        public boolean valid = true;

        InternalEntry(InternalEntry parent, Resource resource, String name) {
            this.parent = parent;
            this.resource = resource;
            this.name = name;
        }
    }
}

