/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.search;

import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.debug.ModuleDebugInfo;
import org.simantics.scl.compiler.module.debug.SymbolReference;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.search.SCLSearchResult;

public class SCLSearchQuery
implements ISearchQuery {
    private SCLSearchResult result;
    private String moduleName;
    private Name valueName;

    public SCLSearchQuery(Name valueName, String localModuleName) {
        this.valueName = valueName;
        this.moduleName = localModuleName;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        SCLSearchResult current = (SCLSearchResult)this.getSearchResult();
        current.removeAll();
        final ModuleRepository repo = SCLOsgi.MODULE_REPOSITORY;
        final Name localName = Name.create((String)this.moduleName, (String)this.valueName.name);
        repo.getSourceRepository().forAllModules((TObjectProcedure)new TObjectProcedure<String>(){

            public boolean execute(String moduleName) {
                Module module;
                ModuleDebugInfo info;
                Failable failableModule = repo.getModule(moduleName);
                if (failableModule.didSucceed() && (info = (module = (Module)failableModule.getResult()).getModuleDebugInfo()) != null) {
                    ArrayList results = info.symbolReferences;
                    for (SymbolReference ref : results) {
                        if (!ref.referred.equals(SCLSearchQuery.this.valueName) && !ref.referred.equals(localName)) continue;
                        SCLSearchQuery.this.result.addMatch(new Match((Object)ref, 1, -1, 1));
                    }
                }
                return true;
            }
        });
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return "Search references for ";
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.result == null) {
            this.result = new SCLSearchResult(this);
            new SearchResultUpdater((AbstractTextSearchResult)this.result);
        }
        return this.result;
    }

    public String getValueName() {
        return this.valueName.toString();
    }
}

