/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor2;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.TextualModuleSource;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.scl.ui.editor2.SCLAnnotationModel;
import org.simantics.scl.ui.editor2.SCLModuleEditorInput;
import org.simantics.scl.ui.editor2.SCLPartitionScanner;

public class SCLModuleEditor2DocumentProvider
extends AbstractDocumentProvider {
    private SCLSourceViewerConfigurationNew sourceViewer;
    protected AnnotationModel annotationModel = new AnnotationModel();
    private Object currentElement;
    private TextualModuleSource currentSource;

    public SCLModuleEditor2DocumentProvider(SCLSourceViewerConfigurationNew sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    private void updateTextualModuleSource(Object input) {
        if (this.currentElement != null && this.currentElement.equals(input)) {
            return;
        }
        this.currentElement = input;
        if (!(this.currentElement instanceof SCLModuleEditorInput)) {
            return;
        }
        ModuleSource source = (ModuleSource)((SCLModuleEditorInput)this.currentElement).getAdapter(ModuleSource.class);
        if (source == null) {
            return;
        }
        if (!(source instanceof TextualModuleSource)) {
            return;
        }
        this.currentSource = (TextualModuleSource)source;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        Document document;
        this.updateTextualModuleSource(element);
        if (this.currentSource == null) {
            throw new CoreException((IStatus)new Status(4, "org.simantics.scl.ui", "Source for the SCL module could not be found."));
        }
        try {
            document = new Document(this.currentSource.getSourceText(null));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.simantics.scl.ui", "Reading SCL module failed.", (Throwable)e));
        }
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new SCLPartitionScanner(), SCLPartitionScanner.PARTITION_TYPES);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.sourceViewer.updateCompletionAssistModuleName(this.currentSource.getModuleName());
        return document;
    }

    public void changed(Object element) {
        this.updateTextualModuleSource(element);
    }

    public void aboutToChange(Object element) {
        super.aboutToChange(element);
    }

    public boolean isModifiable(Object element) {
        if (this.currentSource == null) {
            return false;
        }
        return this.currentSource.isUpdateable();
    }

    public boolean isReadOnly(Object element) {
        return !this.isModifiable(element);
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        SCLModuleEditorInput input = (SCLModuleEditorInput)element;
        return new SCLAnnotationModel(input, SCLOsgi.MODULE_REPOSITORY);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (this.currentSource == null) {
            return;
        }
        this.currentSource.update(document.get());
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }
}

