/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.rules;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.objmap.IFunction;
import org.simantics.objmap.IMappingRule;
import org.simantics.objmap.MappingException;
import org.simantics.objmap.rules.domain.IDomainAccessor;
import org.simantics.objmap.rules.range.IRangeAccessor;

public class MappedElementsRule
implements IMappingRule {
    static Logger LOGGER = Logger.getLogger((String)"org.simantics.objmap");
    IDomainAccessor<Collection<Resource>> domainAccessor;
    IRangeAccessor<Collection<Object>> rangeAccessor;

    public MappedElementsRule(IDomainAccessor<Collection<Resource>> domainAccessor, IRangeAccessor<Collection<Object>> rangeAccessor) {
        this.domainAccessor = domainAccessor;
        this.rangeAccessor = rangeAccessor;
    }

    @Override
    public boolean updateDomain(WriteGraph g, IFunction<Object, Resource> map, Resource domainElement, Object rangeElement) throws MappingException {
        LOGGER.info((Object)"    MappedElementsRule.updateDomain");
        Collection<Object> value = this.rangeAccessor.get(rangeElement);
        Object[] rangeSnapshot = value.toArray();
        ArrayList<Resource> mappedValue = new ArrayList<Resource>(rangeSnapshot.length);
        Object[] objectArray = rangeSnapshot;
        int n = rangeSnapshot.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            mappedValue.add(map.get(obj));
            ++n2;
        }
        return this.domainAccessor.set(g, domainElement, mappedValue);
    }

    @Override
    public boolean updateRange(ReadGraph g, IFunction<Resource, Object> map, Resource domainElement, Object rangeElement) throws MappingException {
        LOGGER.info((Object)"    MappedElementsRule.updateRange");
        Collection<Resource> value = this.domainAccessor.get(g, domainElement);
        ArrayList<Object> mappedValue = new ArrayList<Object>(value.size());
        for (Resource r : value) {
            mappedValue.add(map.get(r));
        }
        return this.rangeAccessor.set(rangeElement, mappedValue);
    }
}

