/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.project.IProject;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.simulation.ui.handlers.ExperimentActivator;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;

public class ActivateExperimentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        final Resource experiment = ResourceAdaptionUtils.toSingleResource((Object)selection);
        if (experiment == null) {
            return null;
        }
        final IProject project = SimanticsUI.peekProject();
        if (project == null) {
            return null;
        }
        final IExperimentManager experimentManager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (experimentManager == null) {
            ErrorLogger.defaultLogWarning((String)"Experiment manager not available.", (Throwable)new Exception());
            return null;
        }
        try {
            project.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    if (graph.isInstanceOf(experiment, SimulationResource.getInstance((ReadGraph)graph).Experiment)) {
                        ExperimentActivator.scheduleActivation((RequestProcessor)graph, project, experimentManager, experiment);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return null;
    }
}

