/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.history.Collector;
import org.simantics.history.HistoryException;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.data.GraphHandle;
import org.simantics.simulation.data.VariableHandle;
import org.simantics.utils.datastructures.Triple;

public class DatasourceAdapter
implements Datasource.DatasourceListener {
    protected Logger logger = Logger.getLogger(DatasourceAdapter.class.toString());
    protected Collector session;
    protected boolean loaded = false;
    protected List<VariableHandle> handles = new ArrayList<VariableHandle>();
    protected List<String> ids = new ArrayList<String>();
    protected List<Binding> bindings = new ArrayList<Binding>();
    protected Set<String> failedIds = new HashSet<String>();
    protected Lock stepLock = new ReentrantLock();

    public DatasourceAdapter(Collector subscription) {
        this.session = subscription;
    }

    public void setSubscriptionSession(Collector session) {
        this.session = session;
    }

    public Collector getSubscriptionSession() {
        return this.session;
    }

    public void flush() throws HistoryException {
        this.session.flush();
    }

    public Lock stepLock() {
        return this.stepLock;
    }

    public void reset() {
        for (VariableHandle h : this.handles) {
            if (h == null) continue;
            h.dispose();
        }
        this.bindings.clear();
        this.handles.clear();
        this.ids.clear();
        this.failedIds.clear();
        this.loaded = false;
    }

    protected void load(Datasource source) {
        this.reset();
        SubscriptionItem[] items = this.session.getItems();
        HashSet<String> idSet = new HashSet<String>(items.length);
        SubscriptionItem[] subscriptionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Datatype variableType;
            SubscriptionItem bean = subscriptionItemArray[n2];
            String variableId = (String)bean.getFieldUnchecked("variableId");
            if (idSet.add(variableId) && (variableType = source.getType(variableId)) != null) {
                Binding valueBinding = Bindings.getBinding((Datatype)variableType);
                VariableHandle handle = source.openHandle((Bean)bean, variableId, valueBinding);
                this.handles.add(handle);
                this.ids.add(variableId);
                this.bindings.add(valueBinding);
            }
            ++n2;
        }
        this.loaded = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void list(Collection<Triple<String, Binding, Object>> result, Collection<GraphHandle> graphHandles) {
        int c = this.ids.size();
        int i = 0;
        while (i < c) {
            block6: {
                Binding binding;
                Object value;
                String key;
                block7: {
                    key = this.ids.get(i);
                    VariableHandle handle = this.handles.get(i);
                    value = null;
                    if (handle == null) break block7;
                    if (handle instanceof GraphHandle) {
                        graphHandles.add((GraphHandle)((Object)handle));
                        break block6;
                    } else {
                        try {
                            value = handle.getValue();
                            binding = this.bindings.get(i);
                            result.add((Triple<String, Binding, Object>)Triple.make((Object)key, (Object)binding, (Object)value));
                        }
                        catch (AccessorException e) {
                            if (this.failedIds.add(key)) {
                                this.logger.log(Level.SEVERE, e.toString(), e);
                            }
                            break block6;
                        }
                    }
                }
                binding = this.bindings.get(i);
                result.add((Triple<String, Binding, Object>)Triple.make((Object)key, (Object)binding, (Object)value));
            }
            ++i;
        }
    }

    @Override
    public void onStep(Datasource source) {
        this.stepLock.lock();
        try {
            try {
                DoubleBinding timeBinding = Bindings.DOUBLE;
                Object time = source.getTime((NumberBinding)timeBinding);
                this.session.beginStep((NumberBinding)timeBinding, time);
                if (!this.loaded) {
                    this.load(source);
                }
                try {
                    int c = this.ids.size();
                    int i = 0;
                    while (i < c) {
                        block22: {
                            Binding binding;
                            String key = this.ids.get(i);
                            VariableHandle handle = this.handles.get(i);
                            Object value = null;
                            if (handle != null) {
                                try {
                                    value = handle.getValue();
                                }
                                catch (AccessorException e) {
                                    if (this.failedIds.add(key)) {
                                        this.logger.log(Level.SEVERE, e.toString(), e);
                                    }
                                    break block22;
                                }
                                binding = handle.binding();
                                try {
                                    this.session.setValue(key, binding, value);
                                }
                                catch (HistoryException e) {
                                    this.logger.log(Level.SEVERE, e.toString(), e);
                                }
                            } else {
                                binding = this.bindings.get(i);
                                if (binding != null) {
                                    this.session.setValue(key, binding, value);
                                }
                            }
                        }
                        ++i;
                    }
                }
                finally {
                    try {
                        this.session.endStep();
                    }
                    catch (HistoryException e) {
                        this.logger.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
            catch (HistoryException e) {
                this.logger.log(Level.SEVERE, e.toString(), e);
                this.stepLock.unlock();
            }
        }
        finally {
            this.stepLock.unlock();
        }
    }

    @Override
    public Executor getExecutor() {
        return null;
    }
}

