/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.simantics.utils.threads.Executable;
import org.simantics.utils.threads.ThreadUtils;

public class ExecutorWorker {
    private static ExecutorWorker instance;
    ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(1);

    public static ExecutorWorker getInstance() {
        if (instance == null) {
            instance = new ExecutorWorker();
        }
        return instance;
    }

    ExecutorWorker() {
    }

    public synchronized ScheduledFuture<Object> timerExec(final Executable executable, int delay) {
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ThreadUtils.asyncExec(executable.threadAccess, executable.runnable);
                return null;
            }
        };
        return this.pool.schedule(c, (long)delay, TimeUnit.MILLISECONDS);
    }

    static class DelayedExecution
    implements Comparable<DelayedExecution> {
        Executable executable;
        long executionTime;

        DelayedExecution() {
        }

        @Override
        public int compareTo(DelayedExecution o) {
            if (o.executionTime < this.executionTime) {
                return -1;
            }
            if (o.executionTime > this.executionTime) {
                return 1;
            }
            return 0;
        }
    }
}

