/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.simantics.acorn.ClusterManager;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.internal.ClusterUpdateProcessorBase;
import org.simantics.acorn.lru.ClusterChangeSet;
import org.simantics.acorn.lru.ClusterStreamChunk;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.ClusterUID;

public class UndoClusterUpdateProcessor
extends ClusterUpdateProcessorBase {
    public static final boolean DEBUG = false;
    private final ClusterChangeSet ccs;
    private int oldValuesIndex = 0;
    private int statementMaskIndex = 0;
    public final List<ClusterChangeSet.Entry> entries = new ArrayList<ClusterChangeSet.Entry>();

    public UndoClusterUpdateProcessor(ClusterManager client, ClusterStreamChunk chunk, ClusterChangeSet ccs) throws DatabaseException {
        super(client, UndoClusterUpdateProcessor.readOperation(client, chunk, ccs));
        this.ccs = ccs;
    }

    private static byte[] readOperation(ClusterManager manager, ClusterStreamChunk chunk, ClusterChangeSet ccs) throws AcornAccessVerificationException, IllegalAcornStateException {
        chunk.makeResident();
        return chunk.getOperation(ccs.chunkOffset);
    }

    @Override
    void create() throws DatabaseException {
    }

    @Override
    void delete(int ri) throws DatabaseException {
        byte[] old = this.ccs.oldValues.get(this.oldValuesIndex);
        boolean oldValueEx = this.ccs.oldValueEx.get(this.oldValuesIndex) > 0;
        ++this.oldValuesIndex;
        if (old != null) {
            this.entries.add(new ClusterChangeSet.Entry(ri, oldValueEx, old, null));
        }
    }

    @Override
    void modify(int resourceKey, long offset, int size, byte[] bytes, int pos) throws DatabaseException {
    }

    @Override
    void set(int resourceKey, byte[] bytes, int length) throws DatabaseException {
        byte[] old = this.ccs.oldValues.get(this.oldValuesIndex);
        boolean oldValueEx = this.ccs.oldValueEx.get(this.oldValuesIndex) > 0;
        ++this.oldValuesIndex;
        this.entries.add(new ClusterChangeSet.Entry(resourceKey, oldValueEx, old, Arrays.copyOf(this.valueBuffer, length)));
    }

    @Override
    void claim(int resourceKey, int predicateKey, int objectKey, ClusterUID puid, ClusterUID ouid) throws DatabaseException {
        boolean add;
        boolean bl = add = this.ccs.statementMask.get(this.statementMaskIndex++) > 0;
        if (add) {
            this.entries.add(new ClusterChangeSet.Entry(ClusterChangeSet.Type.ADD, resourceKey, puid, predicateKey & 0xFFF, ouid, objectKey & 0xFFF));
        }
    }

    @Override
    void deny(int resourceKey, int predicateKey, int objectKey, ClusterUID puid, ClusterUID ouid) throws DatabaseException {
        boolean remove;
        boolean bl = remove = this.ccs.statementMask.get(this.statementMaskIndex++) > 0;
        if (remove) {
            this.entries.add(new ClusterChangeSet.Entry(ClusterChangeSet.Type.REMOVE, resourceKey, puid, predicateKey & 0xFFF, ouid, objectKey & 0xFFF));
        }
    }
}

