/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Properties;
import org.simantics.acorn.GraphClientImpl2;
import org.simantics.db.Database;
import org.simantics.db.DatabaseUserAgent;
import org.simantics.db.ServiceLocator;
import org.simantics.db.server.DatabaseStartException;
import org.simantics.db.server.ProCoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcornDatabase
implements Database {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcornDatabase.class);
    private static final String LOCK_FILE_NAME = "lock";
    private final Path folder;
    private final Path lockFile;
    private GraphClientImpl2 currentClient;
    private DatabaseUserAgent userAgent;
    private RandomAccessFile raLockFile;
    private FileLock lock;
    private boolean isRunning;

    public AcornDatabase(Path folder) {
        this.folder = folder;
        this.lockFile = folder.resolve(LOCK_FILE_NAME);
    }

    public DatabaseUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(DatabaseUserAgent dbUserAgent) {
        this.userAgent = dbUserAgent;
    }

    public Database.Status getStatus() {
        return Database.Status.Local;
    }

    public File getFolder() {
        return this.folder.toFile();
    }

    public boolean isFolderOk() {
        return this.isFolderOk(this.folder.toFile());
    }

    public boolean isFolderOk(File aFolder) {
        return aFolder.isDirectory();
    }

    public boolean isFolderEmpty() {
        return this.isFolderEmpty(this.folder.toFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFolderEmpty(File aFolder) {
        Path path = aFolder.toPath();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryStream<Path> folderStream = Files.newDirectoryStream(path);){
                return !folderStream.iterator().hasNext();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to open folder stream. folder=" + path, (Throwable)e);
            return false;
        }
    }

    public void initFolder(Properties properties) throws ProCoreException {
        try {
            Files.createDirectories(this.folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProCoreException((Throwable)e);
        }
    }

    public void deleteFiles() throws ProCoreException {
        AcornDatabase.deleteTree(this.folder);
    }

    public synchronized void start() throws ProCoreException {
        try {
            this.raLockFile = new RandomAccessFile(this.lockFile.toFile(), "rw");
            this.lock = this.raLockFile.getChannel().tryLock();
            if (this.lock == null) {
                AcornDatabase.safeLoggingClose(this.raLockFile, this.lockFile);
                throw new ProCoreException("The database in folder " + this.folder.toAbsolutePath() + " is already in use!");
            }
            this.isRunning = true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to start database at " + this.folder.toAbsolutePath(), (Throwable)e);
            AcornDatabase.safeLoggingClose(this.raLockFile, this.lockFile);
            throw new ProCoreException("Failed to start database at " + this.folder.toAbsolutePath(), (Throwable)e);
        }
    }

    public boolean isRunning() throws ProCoreException {
        return this.isRunning;
    }

    public synchronized boolean tryToStop() throws ProCoreException {
        if (!this.isRunning) {
            return false;
        }
        try {
            AcornDatabase.safeLoggingClose(this.lock, this.lockFile);
            this.lock = null;
            AcornDatabase.safeLoggingClose(this.raLockFile, this.lockFile);
            this.raLockFile = null;
            Files.deleteIfExists(this.lockFile);
            this.isRunning = false;
        }
        catch (IOException e) {
            LOGGER.error("Failed to start database at " + this.folder.toAbsolutePath(), (Throwable)e);
        }
        return true;
    }

    public void connect() throws ProCoreException {
    }

    public boolean isConnected() throws ProCoreException {
        return this.isRunning;
    }

    public String execute(String command) throws ProCoreException {
        throw new UnsupportedOperationException("execute(" + command + ")");
    }

    public void disconnect() throws ProCoreException {
    }

    public void clone(File to, int revision, boolean saveHistory) throws ProCoreException {
        throw new UnsupportedOperationException();
    }

    public Path createFromChangeSets(int revision) throws ProCoreException {
        throw new UnsupportedOperationException();
    }

    public void deleteGuard() throws ProCoreException {
        throw new UnsupportedOperationException();
    }

    public Path dumpChangeSets() throws ProCoreException {
        throw new UnsupportedOperationException();
    }

    public void purgeDatabase() throws ProCoreException {
        if (this.currentClient == null) {
            throw new IllegalStateException("No current session.");
        }
        this.currentClient.purgeDatabase();
    }

    public long serverGetTailChangeSetId() throws ProCoreException {
        if (this.currentClient == null) {
            throw new IllegalStateException("No current session.");
        }
        return this.currentClient.getTailChangeSetId();
    }

    public Database.Session newSession(ServiceLocator locator) throws ProCoreException {
        try {
            if (this.currentClient != null) {
                throw new DatabaseStartException(this.folder.toFile(), "A session is already running. Only one session is supported.");
            }
            this.currentClient = new GraphClientImpl2(this, this.folder, locator);
            return this.currentClient;
        }
        catch (IOException e) {
            throw new ProCoreException((Throwable)e);
        }
    }

    public Database.Journal getJournal() throws ProCoreException {
        throw new UnsupportedOperationException();
    }

    private static void deleteTree(Path path) throws ProCoreException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            class Visitor
            extends SimpleFileVisitor<Path> {
                Visitor() {
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        throw ioe;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        try {
                            Files.delete(dir);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            throw ioe;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            }
            Visitor v = new Visitor();
            EnumSet<FileVisitOption> opts = EnumSet.noneOf(FileVisitOption.class);
            Files.walkFileTree(path, opts, Integer.MAX_VALUE, v);
        }
        catch (IOException e) {
            throw new ProCoreException("Could not delete " + path, (Throwable)e);
        }
    }

    public String getCompression() {
        return "LZ4";
    }

    private static void safeLoggingClose(AutoCloseable closeable, Path file) {
        if (closeable == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_3 = null;
            try {
                AutoCloseable c = closeable;
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to close " + closeable.getClass() + " of " + file.toAbsolutePath());
        }
    }
}

