/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import java.util.Collection;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.AbstractRemover;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.adapters.Removers;

public class ConnectionRelationRemover
extends AbstractRemover {
    public ConnectionRelationRemover(Resource connectionRelation) {
        super(connectionRelation);
    }

    public String canRemove(ReadGraph graph, Map<Object, Object> aux) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource diagramConnectionRelation = null;
        Resource connectionRelation = graph.getPossibleObject(this.resource, MOD.DiagramConnectionRelationToConnectionRelation);
        if (connectionRelation != null) {
            diagramConnectionRelation = this.resource;
        } else {
            connectionRelation = this.resource;
        }
        Removers.ValidationResult result = Removers.validateConnectionRelationRemoval(graph, connectionRelation, diagramConnectionRelation);
        if (result.inUse()) {
            return Removers.formatError(graph, result);
        }
        return null;
    }

    public void remove(WriteGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Collection lifts = graph.getObjects(this.resource, DIA.Lifts);
        for (Resource def : graph.getObjects(this.resource, L0.ConcernsRelation_Inverse)) {
            graph.deny(def);
        }
        for (Resource diagramConnectionRelation : graph.getObjects(this.resource, MOD.ConnectionRelationToDiagramConnectionRelation)) {
            this.removeTerminals(graph, DIA, diagramConnectionRelation);
            Resource diagramConnectionRelationInverse = graph.getPossibleObject(diagramConnectionRelation, L0.InverseOf);
            graph.deny(diagramConnectionRelation);
            if (diagramConnectionRelationInverse == null) continue;
            graph.deny(diagramConnectionRelationInverse);
        }
        this.removeTerminals(graph, DIA, this.resource);
        Resource connectionRelationInverse = graph.getPossibleObject(this.resource, L0.InverseOf);
        graph.deny(this.resource);
        if (connectionRelationInverse != null) {
            graph.deny(connectionRelationInverse);
        }
        if (!lifts.isEmpty()) {
            for (Resource lift : lifts) {
                RemoverUtil.remove((WriteGraph)graph, (Resource)lift);
            }
        }
    }

    private void removeTerminals(WriteGraph graph, DiagramResource DIA, Resource diagramConnectionRelation) throws DatabaseException {
        for (Resource terminal : graph.getObjects(diagramConnectionRelation, DIA.HasConnectionPoint_Inverse)) {
            for (Resource ownerList : OrderedSetUtils.getOwnerLists((ReadGraph)graph, (Resource)terminal, (Resource)DIA.Composite)) {
                OrderedSetUtils.remove((WriteGraph)graph, (Resource)ownerList, (Resource)terminal);
            }
            RemoverUtil.remove((WriteGraph)graph, (Resource)terminal);
        }
    }
}

