/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.utils;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IToolMode;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.sysdyn.ui.elements.SysdynElementHints;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class SysdynWorkbenchUtils {
    public static IWorkbenchPage getActivePageOfEditor() {
        DiagramEditor editor = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        IWorkbenchPage page = null;
        IWorkbenchWindow[] iWorkbenchWindowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            page = window.getActivePage();
            if (page != null) {
                try {
                    editor = (DiagramEditor)page.getActiveEditor();
                    if (editor != null) {
                        break;
                    }
                }
                catch (ClassCastException classCastException) {}
            }
            ++n2;
        }
        return page;
    }

    public static IToolMode getSysdynToolMode() {
        IWorkbenchPage p = SysdynWorkbenchUtils.getActivePageOfEditor();
        IEditorPart editor = p.getActiveEditor();
        ICanvasContext context = (ICanvasContext)editor.getAdapter(ICanvasContext.class);
        ToolQuery toolQuery = new ToolQuery(context);
        ThreadUtils.syncExec((IThreadWorkQueue)context.getThreadAccess(), (Runnable)toolQuery);
        return toolQuery.getSysdynToolMode();
    }

    static class ToolQuery
    implements Runnable {
        private IToolMode mode;
        private ICanvasContext context;

        ToolQuery(ICanvasContext context) {
            this.context = context;
            this.mode = null;
        }

        @Override
        public void run() {
            IToolMode sysdynMode;
            IHintContext hc = this.context.getDefaultHintContext();
            if (hc == null) {
                return;
            }
            this.mode = sysdynMode = (IToolMode)hc.getHint(SysdynElementHints.SYSDYN_KEY_TOOL);
        }

        public IToolMode getSysdynToolMode() {
            return this.mode;
        }
    }
}

