/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.Session;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.dialogs.SafeMessageDialog;

final class ApplicationUtil {
    ApplicationUtil() {
    }

    public static boolean allowShutdown(AtomicBoolean saveAtExit) {
        block8: {
            try {
                if (!ApplicationUtil.hasUnsavedChanges()) break block8;
                String[] buttons = new String[]{"&Save", "&Don't save", "&Cancel"};
                int result = SafeMessageDialog.doMessageDialog((String)"Save Resources", null, (String)"Save changes before closing ?", (int)3, (String[])buttons, (int)2);
                switch (result) {
                    case 0: {
                        saveAtExit.set(true);
                        break;
                    }
                    case 1: {
                        saveAtExit.set(false);
                        break;
                    }
                    case 2: {
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            catch (RuntimeException e) {
                ErrorLogger.defaultLogError((String)"RuntimeException occured while querying database session for unsaved changes.", (Throwable)e);
                saveAtExit.set(false);
            }
            catch (Error e) {
                ErrorLogger.defaultLogError((String)"Error occured while querying database session for unsaved changes.", (Throwable)e);
                saveAtExit.set(false);
            }
        }
        return true;
    }

    public static boolean hasUnsavedChanges() {
        Session session = SimanticsUI.peekSession();
        if (session == null) {
            return false;
        }
        return false;
    }
}

