/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.internal;

import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.db.service.Bytes;
import org.simantics.db.service.ClusterUID;

public abstract class ClusterUpdateProcessorBase2 {
    private final byte[] bytes;
    private int pos = 0;
    private final int len;
    private final ClusterUID uid;

    public ClusterUpdateProcessorBase2(byte[] operations) {
        this.bytes = operations;
        this.len = Bytes.readLE4((byte[])this.bytes, (int)0) + 4;
        int version = Bytes.readLE4((byte[])this.bytes, (int)4);
        assert (version == 2);
        long cuid1 = Bytes.readLE8((byte[])this.bytes, (int)8);
        long cuid2 = Bytes.readLE8((byte[])this.bytes, (int)16);
        this.pos = 24;
        this.uid = ClusterUID.make((long)cuid1, (long)cuid2);
    }

    public ClusterUID getClusterUID() {
        return this.uid;
    }

    private void processSetImmutable(int op) {
        int value;
        this.setImmutable((value = this.bytes[this.pos++] & 0xFF) > 0);
    }

    private void processUndoValue(int op) {
        Bytes.readLE4((byte[])this.bytes, (int)this.pos);
        this.pos += 4;
    }

    public void process() throws IllegalAcornStateException {
        while (this.pos < this.len) {
            int op = this.bytes[this.pos++] & 0xFF;
            switch (op) {
                case 1: {
                    this.processSetImmutable(op);
                    break;
                }
                case 2: {
                    this.processUndoValue(op);
                    break;
                }
                default: {
                    throw new IllegalAcornStateException("Can not process cluster " + this.uid);
                }
            }
        }
    }

    abstract void setImmutable(boolean var1);
}

