/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.internal;

import java.util.HashMap;
import java.util.Map;
import org.simantics.acorn.ClusterManager;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.internal.ClusterStream;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.Bytes;
import org.simantics.db.service.ClusterUID;

public abstract class ClusterUpdateProcessorBase {
    public static final boolean DEBUG = false;
    protected final ClusterManager manager;
    public final byte[] bytes;
    private int pos = 0;
    private final int len;
    private final ClusterUID uid;
    private final int clusterKey;
    public final int version;
    final Map<ClusterUID, Integer> clusterKeyCache = new HashMap<ClusterUID, Integer>();
    byte[] valueBuffer = new byte[65536];
    ClusterUID[] foreignClusters = new ClusterUID[256];
    int[] foreignIndices = new int[256];
    int foreignPos = 0;
    int[] lows = new int[2];
    int[] foreignRefs = new int[2];

    public int getResourceKey(ClusterUID uid, int index) throws IllegalAcornStateException {
        Integer match = this.clusterKeyCache.get(uid);
        if (match != null) {
            return match + index;
        }
        int key = this.manager.getResourceKeyWitoutMutex(uid, 0);
        this.clusterKeyCache.put(uid, key);
        return key + index;
    }

    public ClusterUpdateProcessorBase(ClusterManager client, byte[] operations) throws DatabaseException {
        this.manager = client;
        this.bytes = operations;
        this.len = Bytes.readLE4((byte[])this.bytes, (int)0) + 4;
        this.version = Bytes.readLE4((byte[])this.bytes, (int)4);
        long cuid1 = Bytes.readLE8((byte[])this.bytes, (int)8);
        long cuid2 = Bytes.readLE8((byte[])this.bytes, (int)16);
        this.uid = ClusterUID.make((long)cuid1, (long)cuid2);
        this.pos = 24;
        client.clusterLRU.acquireMutex();
        try {
            try {
                this.clusterKey = client.clusterLRU.getClusterKeyByUID(cuid1, cuid2) << 12;
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
        finally {
            client.clusterLRU.releaseMutex();
        }
    }

    public ClusterUID getClusterUID() {
        return this.uid;
    }

    private void processCreate() {
        int r = Bytes.readLE2((byte[])this.bytes, (int)this.pos);
        this.pos += 2;
        try {
            this.create();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private void processDelete() {
        int ri = Bytes.readLE2((byte[])this.bytes, (int)this.pos);
        this.pos += 2;
        try {
            this.delete(ri);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private void processModify(int op) {
        int ri = Bytes.readLE2((byte[])this.bytes, (int)this.pos);
        this.pos += 2;
        long offset = Bytes.readLE7((byte[])this.bytes, (int)this.pos);
        this.pos += 7;
        int size = Bytes.readLE2((byte[])this.bytes, (int)this.pos);
        this.pos += 2;
        offset += (long)(ri >> 14 << 56);
        ri &= 0x3FFF;
        if (size < 0) {
            throw new IllegalStateException();
        }
        if (ri < 1) {
            throw new IllegalStateException();
        }
        if (ri > 4095) {
            throw new IllegalStateException();
        }
        try {
            this.modify(this.clusterKey + ri, offset, size, this.bytes, this.pos);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.pos += size;
    }

    private void processSet(int op) {
        int s = Bytes.readLE4((byte[])this.bytes, (int)this.pos);
        int length = s >> 14;
        if (length < 1) {
            throw new IllegalStateException();
        }
        int r = s & 0x3FFF;
        this.pos += 4;
        System.arraycopy(this.bytes, this.pos, this.valueBuffer, 0, length);
        this.pos += length;
        try {
            this.set(this.clusterKey + r, this.valueBuffer, length);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private void processSetShort(int op) {
        int s = Bytes.readLE2((byte[])this.bytes, (int)this.pos);
        int length = ((op & 7) << 2) + (s >> 14);
        if (length < 1) {
            throw new IllegalStateException();
        }
        if (length > 31) {
            throw new IllegalStateException();
        }
        int r = s & 0x3FFF;
        this.pos += 2;
        System.arraycopy(this.bytes, this.pos, this.valueBuffer, 0, length);
        this.pos += length;
        try {
            this.set(this.clusterKey + r, this.valueBuffer, length);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private void processStatementResource(ClusterStream.ClusterEnum enu, int pOrO) {
        if (ClusterStream.ClusterEnum.ForeignShort == enu) {
            int fs;
            this.foreignRefs[pOrO] = fs = this.bytes[this.pos++] & 0xFF;
        } else if (ClusterStream.ClusterEnum.Local == enu) {
            int lo;
            this.lows[pOrO] = lo = this.bytes[this.pos++] & 0xFF;
        } else {
            int lo;
            ClusterUID cuid;
            long l1 = Bytes.readLE8((byte[])this.bytes, (int)this.pos);
            this.pos += 8;
            long l2 = Bytes.readLE8((byte[])this.bytes, (int)this.pos);
            this.pos += 8;
            this.foreignClusters[this.foreignPos] = cuid = ClusterUID.make((long)l1, (long)l2);
            this.foreignIndices[this.foreignPos] = lo = this.bytes[this.pos++] & 0xFF;
            this.foreignRefs[pOrO] = this.foreignPos++;
            this.lows[pOrO] = lo;
        }
    }

    private void processStatement(int op, ClusterStream.StmEnum stmEnum, ClusterStream.ClusterEnum p, ClusterStream.ClusterEnum o) throws IllegalAcornStateException {
        int objectKey;
        ClusterUID puid;
        int curPos = this.pos - 1 - 24;
        this.processStatementResource(p, 0);
        this.processStatementResource(o, 1);
        int ri = this.bytes[this.pos++] & 0xFF;
        int pi = 0;
        int oi = 0;
        ClusterUID ouid = puid = this.uid;
        if (ClusterStream.ClusterEnum.ForeignShort == p && ClusterStream.ClusterEnum.ForeignShort == o) {
            ri |= (op & 0x3F) << 8;
        } else {
            ClusterStream.Data data = ClusterStream.ClusterEnum.getData(stmEnum, p, o);
            if (data.bytes == 0) {
                ri |= (op & 0x3F) << 8;
            } else {
                int extra = 0;
                short opBits = data.bits;
                int extraBits = 6 - opBits;
                if (data.bytes == 1) {
                    extra = this.bytes[this.pos++] & 0xFF;
                    int high = extra >> extraBits;
                    if (ClusterStream.ClusterEnum.ForeignShort == p) {
                        oi = this.lows[1] + (high << 8);
                    } else {
                        pi = this.lows[0] + (high << 8);
                    }
                } else {
                    extra = Bytes.readLE2((byte[])this.bytes, (int)this.pos);
                    this.pos += 2;
                    int high1 = extra >> extraBits & 0x3F;
                    int high2 = extra >> extraBits + 6 & 0x3F;
                    if (ClusterStream.ClusterEnum.ForeignShort == p) {
                        oi = this.lows[1] + (high1 << 8);
                    } else {
                        pi = this.lows[0] + (high1 << 8);
                        oi = this.lows[1] + (high2 << 8);
                    }
                }
                ri = ri | (extra & (1 << extraBits) - 1) << 8 | (op & (1 << opBits) - 1) << 8 + extraBits;
            }
        }
        if (ClusterStream.ClusterEnum.ForeignLong == p) {
            int ref = this.foreignRefs[0];
            this.foreignIndices[ref] = pi;
            puid = this.foreignClusters[ref];
        }
        if (ClusterStream.ClusterEnum.ForeignLong == o) {
            int ref = this.foreignRefs[1];
            this.foreignIndices[ref] = oi;
            ouid = this.foreignClusters[ref];
        }
        if (ClusterStream.ClusterEnum.ForeignShort == p) {
            int ref = this.foreignRefs[0];
            pi = this.foreignIndices[ref];
            puid = this.foreignClusters[ref];
        }
        if (ClusterStream.ClusterEnum.ForeignShort == o) {
            int ref = this.foreignRefs[1];
            oi = this.foreignIndices[ref];
            ouid = this.foreignClusters[ref];
        }
        if (ri < 1) {
            throw new IllegalStateException();
        }
        if (pi < 1) {
            throw new IllegalStateException();
        }
        if (oi < 1) {
            throw new IllegalStateException();
        }
        if (ri > 4095) {
            throw new IllegalStateException();
        }
        if (pi > 4095) {
            throw new IllegalStateException();
        }
        if (oi > 4095) {
            throw new IllegalStateException();
        }
        if (ClusterStream.StmEnum.Add == stmEnum) {
            int predicateKey = this.getResourceKey(puid, pi);
            objectKey = this.getResourceKey(ouid, oi);
            try {
                this.claim(this.clusterKey + ri, predicateKey, objectKey, puid, ouid);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        } else {
            int predicateKey = this.getResourceKey(puid, pi);
            objectKey = this.getResourceKey(ouid, oi);
            try {
                this.deny(this.clusterKey + ri, predicateKey, objectKey, puid, ouid);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
    }

    public void process() throws IllegalAcornStateException {
        this.foreignPos = 0;
        block31: while (this.pos < this.len) {
            int op = this.bytes[this.pos++] & 0xFF;
            block0 : switch (op) {
                case 49: {
                    this.processStatement(op, ClusterStream.StmEnum.Remove, ClusterStream.ClusterEnum.Local, ClusterStream.ClusterEnum.ForeignShort);
                    break;
                }
                case 50: {
                    this.processStatement(op, ClusterStream.StmEnum.Remove, ClusterStream.ClusterEnum.ForeignShort, ClusterStream.ClusterEnum.ForeignLong);
                    break;
                }
                case 51: {
                    this.processStatement(op, ClusterStream.StmEnum.Remove, ClusterStream.ClusterEnum.ForeignLong, ClusterStream.ClusterEnum.ForeignShort);
                    break;
                }
                case 52: {
                    this.processCreate();
                    break;
                }
                case 53: {
                    this.processSet(op);
                    break;
                }
                case 54: {
                    this.processDelete();
                    break;
                }
                case 55: {
                    this.processModify(op);
                    break;
                }
                default: {
                    int bits6 = op & 0xC0;
                    switch (bits6) {
                        case 64: {
                            this.processStatement(op, ClusterStream.StmEnum.Add, ClusterStream.ClusterEnum.ForeignShort, ClusterStream.ClusterEnum.ForeignShort);
                            break block0;
                        }
                        case 128: {
                            this.processStatement(op, ClusterStream.StmEnum.Remove, ClusterStream.ClusterEnum.ForeignShort, ClusterStream.ClusterEnum.ForeignShort);
                            break block0;
                        }
                    }
                    int bits5 = op & 0xE0;
                    if (bits5 == 0) {
                        int bits2 = (op & 0xFC) >> 2;
                        switch (bits2) {
                            case 0: {
                                this.processStatement(op, ClusterStream.StmEnum.Add, ClusterStream.ClusterEnum.Local, ClusterStream.ClusterEnum.Local);
                                break;
                            }
                            case 1: {
                                this.processStatement(op, ClusterStream.StmEnum.Remove, ClusterStream.ClusterEnum.Local, ClusterStream.ClusterEnum.Local);
                                break;
                            }
                            case 2: {
                                this.processStatement(op, ClusterStream.StmEnum.Add, ClusterStream.ClusterEnum.Local, ClusterStream.ClusterEnum.ForeignLong);
                                break;
                            }
                            case 3: {
                                this.processStatement(op, ClusterStream.StmEnum.Remove, ClusterStream.ClusterEnum.Local, ClusterStream.ClusterEnum.ForeignLong);
                                break;
                            }
                            case 4: {
                                this.processStatement(op, ClusterStream.StmEnum.Add, ClusterStream.ClusterEnum.ForeignLong, ClusterStream.ClusterEnum.Local);
                                break;
                            }
                            case 5: {
                                this.processStatement(op, ClusterStream.StmEnum.Remove, ClusterStream.ClusterEnum.ForeignLong, ClusterStream.ClusterEnum.Local);
                                break;
                            }
                            case 6: {
                                this.processStatement(op, ClusterStream.StmEnum.Add, ClusterStream.ClusterEnum.ForeignLong, ClusterStream.ClusterEnum.ForeignLong);
                                break;
                            }
                            case 7: {
                                this.processStatement(op, ClusterStream.StmEnum.Remove, ClusterStream.ClusterEnum.ForeignLong, ClusterStream.ClusterEnum.ForeignLong);
                            }
                        }
                        continue block31;
                    }
                    int bits4 = (op & 0xF0) >> 4;
                    switch (bits4) {
                        case 12: {
                            this.processStatement(op, ClusterStream.StmEnum.Add, ClusterStream.ClusterEnum.Local, ClusterStream.ClusterEnum.ForeignShort);
                            break block0;
                        }
                        case 13: {
                            this.processStatement(op, ClusterStream.StmEnum.Add, ClusterStream.ClusterEnum.ForeignShort, ClusterStream.ClusterEnum.Local);
                            break block0;
                        }
                        case 14: {
                            this.processStatement(op, ClusterStream.StmEnum.Add, ClusterStream.ClusterEnum.ForeignShort, ClusterStream.ClusterEnum.ForeignLong);
                            break block0;
                        }
                        case 15: {
                            this.processStatement(op, ClusterStream.StmEnum.Add, ClusterStream.ClusterEnum.ForeignLong, ClusterStream.ClusterEnum.ForeignShort);
                            break block0;
                        }
                        case 2: {
                            this.processStatement(op, ClusterStream.StmEnum.Remove, ClusterStream.ClusterEnum.ForeignShort, ClusterStream.ClusterEnum.Local);
                            break block0;
                        }
                        case 3: {
                            int bits3 = (op & 0xF8) >> 3;
                            if (bits3 != 7) break block0;
                            this.processSetShort(op);
                        }
                    }
                }
            }
        }
    }

    abstract void create() throws DatabaseException;

    abstract void delete(int var1) throws DatabaseException;

    abstract void modify(int var1, long var2, int var4, byte[] var5, int var6) throws DatabaseException;

    abstract void set(int var1, byte[] var2, int var3) throws DatabaseException;

    abstract void claim(int var1, int var2, int var3, ClusterUID var4, ClusterUID var5) throws DatabaseException;

    abstract void deny(int var1, int var2, int var3, ClusterUID var4, ClusterUID var5) throws DatabaseException;
}

