/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.simantics.databoard.file.RuntimeIOException;

public class FileIO {
    private static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];
    private static final Set<OpenOption> CREATE_OPTIONS = new HashSet<OpenOption>(2);
    private static final Set<OpenOption> APPEND_OPTIONS = new HashSet<OpenOption>(1);
    private Path path;
    private int writePosition = 0;
    private static final boolean TRACE_PERF = false;

    static {
        CREATE_OPTIONS.add(StandardOpenOption.WRITE);
        CREATE_OPTIONS.add(StandardOpenOption.CREATE);
        APPEND_OPTIONS.add(StandardOpenOption.APPEND);
    }

    public FileIO(Path path) {
        this.path = path;
    }

    public synchronized int saveBytes(byte[] bytes, int length, boolean overwrite) throws IOException {
        if (overwrite) {
            this.writePosition = 0;
        }
        int result = this.writePosition;
        long start = System.nanoTime();
        Set<OpenOption> options = this.writePosition == 0 ? CREATE_OPTIONS : APPEND_OPTIONS;
        ByteBuffer bb = ByteBuffer.wrap(bytes, 0, length);
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try (FileChannel fc = FileChannel.open(this.path, options, NO_ATTRIBUTES);){
                fc.write(bb);
                this.writePosition += length;
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            throw new IOException("An error occured file saving bytes for file " + this.path.toAbsolutePath().toString(), t);
        }
    }

    public synchronized byte[] readBytes(int offset, int length) throws IOException {
        long start = System.nanoTime();
        Throwable throwable = null;
        Object var6_6 = null;
        try (SeekableByteChannel channel = Files.newByteChannel(this.path, new OpenOption[0]);){
            channel.position(offset);
            ByteBuffer buf = ByteBuffer.allocate(length);
            int read = 0;
            while (read < length) {
                read += channel.read(buf);
            }
            byte[] result = buf.array();
            if (result.length != length) {
                System.err.println("faa");
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void syncPath(Path f) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (RandomAccessFile raf = new RandomAccessFile(f.toFile(), "rw");){
            raf.getFD().sync();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static void uncheckedSyncPath(Path f) {
        try {
            FileIO.syncPath(f);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        byte[] buf = new byte[0x100000];
        long s = System.nanoTime();
        Path test = Paths.get("e:/work/test.dat", new String[0]);
        OutputStream fs = Files.newOutputStream(test, new OpenOption[0]);
        BufferedOutputStream os = new BufferedOutputStream(fs, 131072);
        int i = 0;
        while (i < 40) {
            ((OutputStream)os).write(buf);
            ++i;
        }
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        FileIO.syncPath(test);
        long duration = System.nanoTime() - s;
        System.err.println("Took " + 1.0E-6 * (double)duration + "ms.");
    }
}

