/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.data.xml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.IllegalAddException;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderXSDFactory;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.scl.runtime.reporting.SCLReporting;

public class JDomHelper {
    private static final SAXBuilder BUILDER = new SAXBuilder();
    private static final XMLOutputter OUTPUTTER = new XMLOutputter(Format.getPrettyFormat());
    private static final XPathFactory XPATH_FACTORY = XPathFactory.instance();
    private static final int XPATH_CACHE_MAX = 50;
    private static final Map<String, XPathExpression<Element>> XPATH_CACHE = Collections.synchronizedMap(new LinkedHashMap<String, XPathExpression<Element>>(50){
        private static final long serialVersionUID = 2546245625L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, XPathExpression<Element>> eldest) {
            return this.size() > 50;
        }
    });

    public static Document parseString(String xmlDocument) throws JDOMException, IOException {
        return BUILDER.build((Reader)new StringReader(xmlDocument));
    }

    public static Document parseFile(String xmlFileName) throws JDOMException, IOException {
        return BUILDER.build(new File(xmlFileName));
    }

    public static String outputString(Document document) throws IOException {
        StringWriter writer = new StringWriter();
        OUTPUTTER.output(document, (Writer)writer);
        return writer.toString();
    }

    private static XPathExpression<Element> getXPathExpression(String xPathText) {
        XPathExpression expression = XPATH_CACHE.get(xPathText);
        if (expression == null) {
            expression = XPATH_FACTORY.compile(xPathText, Filters.element());
            XPATH_CACHE.put(xPathText, (XPathExpression<Element>)expression);
        }
        return expression;
    }

    public static List<Element> elementsByXPath(Element element, String xPathText) {
        XPathExpression<Element> expr = JDomHelper.getXPathExpression(xPathText);
        return expr.evaluate((Object)element);
    }

    public static void addNamedChild(Element parent, String name, Element child) {
        child.setName(name);
        try {
            parent.addContent((Content)child);
        }
        catch (IllegalAddException e) {
            SCLReporting.printError((String)("Failed to set the parent of an element " + name + ":"));
            SCLReporting.printError((String)("    " + e.getMessage()));
        }
    }

    public static void setNamespace(Document document, String namespace) {
        JDomHelper.setElementNamespace(document.getRootElement(), namespace);
    }

    public static void setElementNamespace(Element element, String namespace) {
        Namespace ns = Namespace.getNamespace((String)namespace);
        JDomHelper.setNamespaceRecursively(element, ns);
    }

    private static void setNamespaceRecursively(Element element, Namespace ns) {
        element.setNamespace(ns);
        for (Element child : element.getChildren()) {
            if (child.getNamespace() != Namespace.NO_NAMESPACE) continue;
            JDomHelper.setNamespaceRecursively(child, ns);
        }
    }

    public static void clearNamespace(Document document) {
        JDomHelper.clearElementNamespace(document.getRootElement());
    }

    public static void clearElementNamespace(Element element) {
        element.setNamespace(null);
        for (Element child : element.getChildren()) {
            JDomHelper.clearElementNamespace(child);
        }
    }

    public static Function parseStringWithSchemaFile(String xsdFile) throws JDOMException {
        XMLReaderXSDFactory factory = new XMLReaderXSDFactory(new File[]{new File(xsdFile)});
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)factory);
        return JDomHelper.parseStringWithBuilder(builder);
    }

    public static Function parseStringWithSchemaURL(URL xsd) throws JDOMException {
        XMLReaderXSDFactory factory = new XMLReaderXSDFactory(new URL[]{xsd});
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)factory);
        return JDomHelper.parseStringWithBuilder(builder);
    }

    public static Function parseFileWithSchemaFile(String xsdFile) throws JDOMException {
        XMLReaderXSDFactory factory = new XMLReaderXSDFactory(new File[]{new File(xsdFile)});
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)factory);
        return JDomHelper.parseFileWithBuilder(builder);
    }

    public static Function parseFileWithSchemaURL(URL xsd) throws JDOMException {
        XMLReaderXSDFactory factory = new XMLReaderXSDFactory(new URL[]{xsd});
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)factory);
        return JDomHelper.parseFileWithBuilder(builder);
    }

    private static Function parseStringWithBuilder(final SAXBuilder builder) {
        return new FunctionImpl1<String, Document>(){

            public Document apply(String xml) {
                try {
                    return builder.build((Reader)new StringReader(xml));
                }
                catch (IOException | JDOMException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static Function parseFileWithBuilder(final SAXBuilder builder) {
        return new FunctionImpl1<String, Document>(){

            public Document apply(String xml) {
                try {
                    return builder.build(new File(xml));
                }
                catch (IOException | JDOMException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static void sortChildrenWith(final Function comparator, Element element) {
        element.sortChildren(new Comparator(){

            public int compare(Object o1, Object o2) {
                return (Integer)comparator.apply(o1, o2);
            }
        });
    }
}

