/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.utils.imports;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.simantics.Simantics;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataFormatException;
import org.simantics.databoard.container.FormatHandler;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.representation.TransferableGraph1;

public class SysdynImportFormatHandler
implements FormatHandler<Object> {
    private final Resource parent;
    private final IProgressMonitor monitor;
    private final String migrationURI;
    private final DefaultPasteImportAdvisor importAdvisor;

    public SysdynImportFormatHandler(Resource parent, String migrationURI, IProgressMonitor monitor) {
        this(parent, migrationURI, monitor, null);
    }

    public SysdynImportFormatHandler(Resource parent, String migrationURI, IProgressMonitor monitor, DefaultPasteImportAdvisor importAdvisor) {
        assert (parent != null);
        assert (migrationURI != null);
        this.parent = parent;
        this.monitor = monitor;
        this.migrationURI = migrationURI;
        this.importAdvisor = importAdvisor;
    }

    private void subTask(String taskName) {
        if (this.monitor != null) {
            this.monitor.subTask(taskName);
        }
    }

    private void worked(int work) {
        if (this.monitor != null) {
            this.monitor.worked(work);
        }
    }

    public Binding getBinding() {
        return TransferableGraph1.BINDING;
    }

    public Object process(DataContainer container) throws DataFormatException {
        DefaultPasteImportAdvisor ia = this.importAdvisor != null ? this.importAdvisor : new DefaultPasteImportAdvisor(this.parent);
        try {
            this.subTask("Migrate");
            Session session = Simantics.getSession();
            TransferableGraph1 tg = (TransferableGraph1)container.content.getValue();
            MigrationStep step = MigrationUtils.getStep((Session)session, (String)this.migrationURI);
            MigrationState state = MigrationUtils.newState();
            state.setProperty("currentTG", (Object)tg);
            step.applyTo(this.monitor, session, state);
            this.worked(1);
            this.subTask("Import");
            MigrationUtils.importTo((IProgressMonitor)this.monitor, (Session)session, (MigrationState)state, (Resource)this.parent, (IImportAdvisor)ia);
            this.worked(1);
            Resource result = (Resource)state.getProperty("currentResource");
            if (result == null) {
                result = ia.getRoot();
            }
            return result;
        }
        catch (Exception e) {
            return new Status(4, "org.simantics.sysdyn", "Import module failed", (Throwable)e);
        }
    }
}

