/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.simulation;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.simantics.modelica.IModelicaMonitor;
import org.simantics.sysdyn.manager.OldSysdynExperiment;
import org.simantics.sysdyn.manager.SysdynConsole;
import org.simantics.sysdyn.manager.SysdynModel;

public class SimulationJob
extends Job {
    private SysdynModel model;
    private OldSysdynExperiment experiment;
    private IModelicaMonitor monitor;

    public SimulationJob(SysdynModel model, OldSysdynExperiment experiment) {
        super("Simulate " + model.getConfiguration().getLabel());
        this.model = model;
        this.experiment = experiment;
        this.monitor = PlatformUI.isWorkbenchRunning() ? SysdynConsole.INSTANCE : new HeadlessModelicaMonitor();
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Simulate " + this.model.getConfiguration().getLabel(), this.experiment.numberOfSimulationRunSteps());
        try {
            this.model.update();
            if (this.experiment instanceof OldSysdynExperiment) {
                this.experiment.simulate(this.monitor, monitor, this.model.getConfiguration().getLabel());
                this.model.setStructureModified(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.monitor.showConsole();
            return new Status(4, "org.simantics.sysdyn.ui", "Simulation failed: \n" + e.getMessage());
        }
        this.monitor.message("\n");
        monitor.done();
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return "SimulationJob".equals(family);
    }

    protected void canceling() {
    }

    public static class HeadlessModelicaMonitor
    implements IModelicaMonitor {
        public void message(String message) {
            this.message(message, "hh:mm:ss");
        }

        public void message(String message, String timeStampFormat) {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat(timeStampFormat);
            String time = sdf.format(cal.getTime());
            System.out.println("[" + time + "] " + message);
        }

        public void clearConsole() {
        }

        public void showConsole() {
        }
    }
}

