/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.procedures;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;
import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.graph.compiler.ExternalFileLoader;
import org.simantics.graph.compiler.internal.store.LocationStore;
import org.simantics.graph.compiler.internal.templates.BuiltinTemplates;
import org.simantics.graph.compiler.internal.templates.GraphTemplate;
import org.simantics.graph.compiler.internal.templates.ITemplate;
import org.simantics.graph.compiler.internal.templates.TemplateInstanceStore;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.Paths;
import org.simantics.graph.query.Res;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.store.GraphStore;
import org.simantics.ltk.Location;
import org.simantics.ltk.Problem;

public class ApplyTemplates
implements Runnable {
    IGraph graph;
    GraphStore store;
    Collection<Problem> problems;
    ExternalFileLoader fileLoader;
    BuiltinTemplates builtinTemplates;
    TIntObjectHashMap<ITemplate> cache = new TIntObjectHashMap();

    public ApplyTemplates(IGraph graph, GraphStore store, Collection<Problem> problems, ExternalFileLoader fileLoader) {
        this.graph = graph;
        this.store = store;
        this.problems = problems;
        this.fileLoader = fileLoader;
        this.builtinTemplates = new BuiltinTemplates(graph.getPaths());
    }

    ITemplate getTemplate(int id) {
        ITemplate template = (ITemplate)this.cache.get(id);
        if (template == null) {
            template = this.createTemplate(id);
            this.cache.put(id, (Object)template);
        }
        return template;
    }

    ITemplate createTemplate(int id) {
        ITemplate template;
        Res res = this.store.idToRes(id);
        if (res instanceof Path && (template = (ITemplate)this.builtinTemplates.TEMPLATES.get((Object)((Path)res))) != null) {
            return template;
        }
        Paths paths = this.graph.getPaths();
        try {
            Res template2 = this.graph.singleRawObject(res, (Res)paths.HasTemplate);
            TransferableGraph1 tg = (TransferableGraph1)this.graph.getValue(template2, TransferableGraph1.BINDING);
            Res templateParameters = this.graph.singleRawObject(res, (Res)paths.HasTemplateParameters);
            String[] parameters = (String[])this.graph.getValue(templateParameters).getValue((Binding)Bindings.STRING_ARRAY);
            return new GraphTemplate(this.store, parameters, tg);
        }
        catch (Exception e) {
            Location location = ((LocationStore)this.store.getStore(LocationStore.class)).getLocation(id);
            this.problems.add(new Problem(location, e.getMessage()));
            return null;
        }
    }

    @Override
    public void run() {
        TemplateInstanceStore templateStore = (TemplateInstanceStore)this.store.getStore(TemplateInstanceStore.class);
        if (templateStore == null) {
            return;
        }
        for (int[] inst : templateStore.getTemplateInstances()) {
            ITemplate template = this.getTemplate(inst[0]);
            if (template == null) continue;
            template.apply(this.graph, this.store, Arrays.copyOfRange(inst, 1, inst.length), this.fileLoader, this.problems);
        }
    }
}

