/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.adapter.PasteHandler;
import org.simantics.db.layer0.adapter.impl.DefaultCopyHandler;
import org.simantics.db.layer0.adapter.impl.DefaultPasteHandler;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.PartialIC;
import org.simantics.modeling.scl.SCLRealm;
import org.simantics.modeling.scl.SCLSessionManager;
import org.simantics.project.IProject;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.model.ExperimentLoadingFailed;
import org.simantics.simulation.project.IExperimentActivationListener;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.OldSysdynExperiment;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.utils.DataContainer;

public class SysdynExperiments {
    public static void setPublishResults(ReadGraph graph, Variable variable, boolean value) throws DatabaseException {
        IProject project = Simantics.getProject();
        if (project == null) {
            return;
        }
        IExperimentManager experimentManager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (experimentManager == null) {
            return;
        }
        IExperiment exp = experimentManager.getExperiment(variable.getName(graph));
        if (exp instanceof OldSysdynExperiment) {
            OldSysdynExperiment experiment = (OldSysdynExperiment)exp;
            experiment.setPublishResults(value);
        }
    }

    public static String activateExperiment(IProgressMonitor monitor, IProject project, IExperimentManager manager, Resource experimentResource) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Activating experiment", (int)100000);
        IExperiment[] experiments = manager.getExperiments();
        SubMonitor shutdownMon = mon.newChild(10000);
        int workPerExperiment = experiments.length > 0 ? 10000 / experiments.length : 10000;
        IExperiment[] iExperimentArray = experiments;
        int n = experiments.length;
        int n2 = 0;
        while (n2 < n) {
            IExperiment e = iExperimentArray[n2];
            if (e.getState() != ExperimentState.DISPOSED) {
                e.shutdown((IProgressMonitor)shutdownMon.newChild(workPerExperiment));
            }
            ++n2;
        }
        mon.setWorkRemaining(90000);
        final Semaphore activated = new Semaphore(0);
        final DataContainer problem = new DataContainer();
        final DataContainer run = new DataContainer();
        manager.startExperiment(experimentResource, new IExperimentActivationListener(){

            public void onExperimentActivated(IExperiment experiment) {
                run.set((Object)experiment);
                activated.release();
            }

            public void onFailure(Throwable e) {
                problem.set((Object)e);
                activated.release();
            }

            public void onMessage(IStatus message) {
            }

            public IProgressMonitor getProgressMonitor() {
                return mon;
            }
        }, true);
        try {
            activated.acquire();
            Throwable t = (Throwable)problem.get();
            if (t != null) {
                boolean cfr_ignored_0 = t instanceof ExperimentLoadingFailed;
            }
            return ((IExperiment)run.get()).getIdentifier();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public static String activateExperiment(Resource experiment) {
        IProject project = Simantics.getProject();
        if (project == null) {
            return null;
        }
        IExperimentManager experimentManager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (experimentManager == null) {
            return null;
        }
        return SysdynExperiments.activateExperiment(null, project, experimentManager, experiment);
    }

    public static void run(String experimentId) {
        IProject project = Simantics.getProject();
        if (project == null) {
            return;
        }
        IExperimentManager experimentManager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (experimentManager == null) {
            return;
        }
        IExperiment experiment = experimentManager.getExperiment(experimentId);
        if (experiment instanceof IDynamicExperiment) {
            ((IDynamicExperiment)experiment).simulate(true);
        }
    }

    public static List<Tuple2> experimentResult(String experimentId, String variableName) {
        IProject project = Simantics.getProject();
        if (project == null) {
            return null;
        }
        IExperimentManager experimentManager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (experimentManager == null) {
            return null;
        }
        IExperiment experiment = experimentManager.getExperiment(experimentId);
        if (!(experiment instanceof SysdynExperiment)) {
            return null;
        }
        SysdynDataSet dataset = ((SysdynExperiment)experiment).getCurrentResult().getDataSet(variableName);
        if (dataset == null) {
            return null;
        }
        ArrayList<Tuple2> results = new ArrayList<Tuple2>();
        int i = 0;
        while (i < dataset.times.length) {
            results.add(new Tuple2((Object)dataset.times[i], (Object)dataset.values[i]));
            ++i;
        }
        return results;
    }

    private static void processChild(ReadGraph graph, Variable child, PartialIC IC) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        for (Variable c : child.getChildren(graph)) {
            Resource type = c.getPossibleType(graph);
            if (type == null || !graph.isInheritedFrom(type, STR.Component)) continue;
            SysdynExperiments.processChild(graph, c, IC);
        }
        Variable values = child.getPossibleProperty(graph, "values");
        if (values == null) {
            return;
        }
        Resource represents = child.getPossibleRepresents(graph);
        if (represents == null) {
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
        Collection exprs = (Collection)graph.syncRequest((Read)new ObjectsWithType(represents, L0.ConsistsOf, SYSDYN.ParameterExpression));
        if (exprs.size() == 0 && graph.hasStatement(represents, SYSDYN.Variable_isHeadOf)) {
            return;
        }
        Variable v = values.getPossibleProperty(graph, "");
        if (v == null) {
            return;
        }
        double[][] vs = (double[][])v.getValue(graph);
        Variable value = child.getPossibleProperty(graph, "value");
        if (value == null) {
            return;
        }
        int i = 0;
        while (i < vs.length) {
            Variable target;
            double[] ds = vs[i];
            if (ds != null && (target = value.getPossibleProperty(graph, "$" + i)) != null && ds.length > 0) {
                RVI rvi = target.getRVI(graph);
                double initial = ds[0];
                IC.add(rvi, Variant.ofInstance((Object)initial));
            }
            ++i;
        }
    }

    public static Resource saveIC(WriteGraph graph, Variable input) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)input);
        String name = NameUtils.findFreshName((ReadGraph)graph, (String)"IC", (Resource)model, (Resource)L0.ConsistsOf);
        return SysdynExperiments.saveIC(graph, input, name);
    }

    public static Resource saveIC(WriteGraph graph, Variable input, String name) throws DatabaseException {
        return SysdynExperiments.saveIC2(graph, null, input, name);
    }

    public static Resource saveIC2(WriteGraph graph, Variable session, Variable input, String name) throws DatabaseException {
        Resource state;
        graph.markUndoPoint();
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)input);
        Resource child = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)model, (String)name);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
        if (child != null) {
            if (graph.isInstanceOf(child, SYSDYN.InitialCondition)) {
                RemoverUtil.remove((WriteGraph)graph, (Resource)child);
            } else {
                return null;
            }
        }
        PartialIC IC = new PartialIC();
        SysdynExperiments.processChild((ReadGraph)graph, input, IC);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource ic = graph.newResource();
        graph.claim(ic, L0.InstanceOf, SYSDYN.InitialCondition);
        graph.addLiteral(ic, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        graph.addLiteral(ic, SYSDYN.InitialCondition_HasInitialValues, SYSDYN.InitialCondition_HasInitialValues_Inverse, MOD.PartialIC, (Object)IC, PartialIC.BINDING);
        graph.claim(model, L0.ConsistsOf, ic);
        Resource represents = input.getPossibleRepresents((ReadGraph)graph);
        if (represents != null && (state = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)represents, (String)"__simupedia__")) != null) {
            Layer0Utils.copyTo((WriteGraph)graph, (Resource)ic, (Resource)state, null, (CopyHandler)new DefaultCopyHandler(state){

                protected boolean ignoreVirtualResources() {
                    return false;
                }
            }, (PasteHandler)new DefaultPasteHandler(ic));
        }
        if (session != null) {
            SCLRealm realm = SCLSessionManager.sclRealmById((String)(String.valueOf(session.getURI((ReadGraph)graph)) + "/__icstate__"));
            byte[] values = realm.serialize();
            Resource sclState = graph.newResource();
            graph.claim(sclState, L0.InstanceOf, MOD.SCLState);
            graph.claimLiteral(sclState, MOD.SCLState_identifier, MOD.SCLState_identifier_Inverse, L0.String, (Object)"__icstate__", (Binding)Bindings.STRING);
            graph.claimLiteral(sclState, MOD.SCLState_blob, MOD.SCLState_blob_Inverse, L0.ByteArray, (Object)values, (Binding)Bindings.BYTE_ARRAY);
            graph.claim(ic, MOD.InitialCondition_HasSCLState, sclState);
        }
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Saved new Initial Condition " + name + " " + ic));
        return ic;
    }

    public static void assignIC(WriteGraph graph, Variable experiment, String name) throws DatabaseException {
        Resource storedState;
        graph.markUndoPoint();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
        final Resource run = experiment.getPossibleRepresents((ReadGraph)graph);
        if (run == null) {
            return;
        }
        Resource exp = graph.getPossibleObject(run, L0.PartOf);
        if (exp == null) {
            return;
        }
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)experiment);
        Resource ic = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)model, (String)name);
        if (ic == null) {
            return;
        }
        if (!graph.isInstanceOf(ic, SYSDYN.InitialCondition)) {
            return;
        }
        graph.deny(exp, SYSDYN.Experiment_ic);
        graph.claim(exp, SYSDYN.Experiment_ic, ic);
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Assigned Initial Condition " + graph.getRelatedValue2(ic, L0.HasName, (Binding)Bindings.STRING) + " to experiment " + graph.getRelatedValue2(exp, L0.HasName, (Binding)Bindings.STRING)));
        Resource oldState = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)run, (String)"__simupedia__");
        if (oldState != null) {
            graph.deny(run, L0.ConsistsOf, oldState);
        }
        if ((storedState = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)ic, (String)"__simupedia__")) != null) {
            VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
            graph.syncRequest((Write)new WriteRequest(vgs.getMemoryPersistent("experiments")){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0Utils.copyTo((WriteGraph)graph, (Resource)run, (Resource)storedState, null, (CopyHandler)new DefaultCopyHandler(storedState), (PasteHandler)new DefaultPasteHandler(run));
                }
            });
        }
    }

    public static void deassignIC(WriteGraph graph, Variable experiment) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
        Resource run = experiment.getPossibleRepresents((ReadGraph)graph);
        if (run == null) {
            return;
        }
        Resource exp = graph.getPossibleObject(run, L0.PartOf);
        if (exp == null) {
            return;
        }
        graph.deny(exp, SYSDYN.Experiment_ic);
    }

    public static void applyIC(WriteGraph graph, Variable experiment, String name) throws DatabaseException {
        SysdynExperiments.applyIC2(graph, null, experiment, name);
    }

    public static void applyIC2(WriteGraph graph, Variable session, Variable experiment, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
        Resource run = experiment.getPossibleRepresents((ReadGraph)graph);
        if (run == null) {
            return;
        }
        Resource exp = graph.getPossibleObject(run, L0.PartOf);
        if (exp == null) {
            return;
        }
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)experiment);
        Resource ic = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)model, (String)name);
        if (ic == null) {
            return;
        }
        if (!graph.isInstanceOf(ic, SYSDYN.InitialCondition)) {
            return;
        }
        Variable base = Variables.getVariable((ReadGraph)graph, (Resource)run);
        SysdynExperiments.setPublishResults((ReadGraph)graph, base, false);
        PartialIC data = (PartialIC)graph.getPossibleRelatedValue(ic, SYSDYN.InitialCondition_HasInitialValues, PartialIC.BINDING);
        data.apply(graph, base);
        if (session != null) {
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            for (Resource sclState : graph.getObjects(ic, MOD.InitialCondition_HasSCLState)) {
                String identifier = (String)graph.getRelatedValue(sclState, MOD.SCLState_identifier);
                if (!"__icstate__".equals(identifier)) continue;
                byte[] blob = (byte[])graph.getRelatedValue(sclState, MOD.SCLState_blob);
                SCLRealm realm = SCLSessionManager.sclRealmById((String)(String.valueOf(session.getURI((ReadGraph)graph)) + "/__icstate__"));
                realm.applyState(blob);
                realm.refreshVariablesSync();
            }
        }
        SysdynExperiments.setPublishResults((ReadGraph)graph, base, true);
    }

    public static void deleteIC(WriteGraph graph, Variable input, String name) throws DatabaseException {
        graph.markUndoPoint();
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)input);
        Resource child = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)model, (String)name);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
        if (child != null && graph.isInstanceOf(child, SYSDYN.InitialCondition)) {
            String actualName = (String)graph.getRelatedValue2(child, L0.HasName, (Binding)Bindings.STRING);
            RemoverUtil.remove((WriteGraph)graph, (Resource)child);
            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Deleted Initial Condition " + actualName));
        }
    }
}

