/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter.distribution;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.adapter.distribution.IDistribution;

public class NormalDistribution
implements IDistribution {
    private Double min = null;
    private Double max = null;
    private double minProbability = 0.0;
    private double maxProbability = 1.0;
    private double mean;
    private double stdDeviation;
    protected double m;
    protected double sd;
    private static final double[] a = new double[]{2.2352520354606837, 161.02823106855587, 1067.6894854603709, 18154.98125334356, 0.06568233791820745};
    private static final double[] b = new double[]{47.202581904688245, 976.0985517377767, 10260.932208618979, 45507.78933502673};
    private static final double[] c = new double[]{0.39894151208813466, 8.883149794388377, 93.50665613217785, 597.2702763948002, 2494.5375852903726, 6848.190450536283, 11602.65143764735, 9842.714838383978, 1.0765576773720192E-8};
    private static final double[] d = new double[]{22.266688044328117, 235.387901782625, 1519.3775994075547, 6485.558298266761, 18615.571640885097, 34900.95272114598, 38912.00328609327, 19685.429676859992};
    private static final double[] p_ = new double[]{0.215898534057957, 0.12740116116024736, 0.022235277870649807, 0.0014216191932278934, 2.9112874951168793E-5, 0.023073441764940174};
    private static final double[] q = new double[]{1.284260096144911, 0.4682382124808651, 0.06598813786892856, 0.0037823963320275824, 7.297515550839662E-5};
    private static final int CUTOFF = 16;
    private static final double M_SQRT_32 = 5.656854249492381;
    private static final double M_1_SQRT_2PI = 0.3989422804014327;
    private static final double DBL_EPSILON = 2.220446049250313E-16;

    public NormalDistribution(ReadGraph graph, Resource distribution) {
        try {
            SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
            this.min = (Double)graph.getPossibleRelatedValue(distribution, SR.NormalDistribution_minValue, (Binding)Bindings.DOUBLE);
            this.max = (Double)graph.getPossibleRelatedValue(distribution, SR.NormalDistribution_maxValue, (Binding)Bindings.DOUBLE);
            this.stdDeviation = (Double)graph.getPossibleRelatedValue(distribution, SR.NormalDistribution_stdDeviation, (Binding)Bindings.DOUBLE);
            this.mean = (Double)graph.getPossibleRelatedValue(distribution, SR.NormalDistribution_mean, (Binding)Bindings.DOUBLE);
            if (this.min != null) {
                this.minProbability = NormalDistribution.cdf(this.min, this.mean, this.stdDeviation, false);
            }
            if (this.max != null) {
                this.maxProbability = NormalDistribution.cdf(this.max, this.mean, this.stdDeviation, false);
            }
        }
        catch (DatabaseException databaseException) {}
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    @Override
    public double inverseCDF(double probability) {
        double mappedProbability = this.minProbability + (this.maxProbability - this.minProbability) * probability;
        return NormalDistribution.quantile(mappedProbability, this.mean, this.stdDeviation);
    }

    public static double quantile(double z, double m, double sd) {
        return m + Math.sqrt(2.0) * sd * NormalDistribution.inverseErf(2.0 * z - 1.0);
    }

    public static double cdf(double x, double mu, double sigma, boolean log_p) {
        boolean i_tail = false;
        double cp = Double.NaN;
        if (Double.isNaN(x) || Double.isNaN(mu) || Double.isNaN(sigma)) {
            return Double.NaN;
        }
        if (Double.isInfinite(x) && mu == x) {
            return Double.NaN;
        }
        if (sigma <= 0.0) {
            if (sigma < 0.0) {
                return Double.NaN;
            }
            return x < mu ? 0.0 : 1.0;
        }
        double p = (x - mu) / sigma;
        if (Double.isInfinite(p)) {
            return x < mu ? 0.0 : 1.0;
        }
        x = p;
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        double eps = 1.110223E-16f;
        boolean lower = !i_tail;
        boolean upper = i_tail;
        double y = Math.abs(x);
        if (y <= 0.67448975) {
            double xden;
            double xnum;
            if (y > eps) {
                double xsq = x * x;
                xnum = a[4] * xsq;
                xden = xsq;
                int i = 0;
                while (i < 3) {
                    xnum = (xnum + a[i]) * xsq;
                    xden = (xden + b[i]) * xsq;
                    ++i;
                }
            } else {
                xden = 0.0;
                xnum = 0.0;
            }
            double temp = x * (xnum + a[3]) / (xden + b[3]);
            if (lower) {
                p = 0.5 + temp;
            }
            if (upper) {
                cp = 0.5 - temp;
            }
            if (log_p) {
                if (lower) {
                    p = Math.log(p);
                }
                if (upper) {
                    cp = Math.log(cp);
                }
            }
        } else if (y <= 5.656854249492381) {
            double xnum = c[8] * y;
            double xden = y;
            int i = 0;
            while (i < 7) {
                xnum = (xnum + c[i]) * y;
                xden = (xden + d[i]) * y;
                ++i;
            }
            double temp = (xnum + c[7]) / (xden + d[7]);
            double xsq = (double)((int)(y * 16.0)) * 1.0 / 16.0;
            double del = (y - xsq) * (y + xsq);
            if (log_p) {
                p = -xsq * xsq * 0.5 + -del * 0.5 + Math.log(temp);
                if (lower && x > 0.0 || upper && x <= 0.0) {
                    cp = Math.log(1.0 - Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp);
                }
            } else {
                p = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp;
                cp = 1.0 - p;
            }
            if (x > 0.0) {
                temp = p;
                if (lower) {
                    p = cp;
                }
                cp = temp;
            }
        } else if (log_p || lower && -37.5193 < x && x < 8.2924 || upper && -8.2924 < x && x < 37.5193) {
            double xsq = 1.0 / (x * x);
            double xnum = p_[5] * xsq;
            double xden = xsq;
            int i = 0;
            while (i < 4) {
                xnum = (xnum + p_[i]) * xsq;
                xden = (xden + q[i]) * xsq;
                ++i;
            }
            double temp = xsq * (xnum + p_[4]) / (xden + q[4]);
            temp = (0.3989422804014327 - temp) / y;
            xsq = (double)((int)(x * 16.0)) * 1.0 / 16.0;
            double del = (x - xsq) * (x + xsq);
            if (log_p) {
                p = -xsq * xsq * 0.5 + -del * 0.5 + Math.log(temp);
                if (lower && x > 0.0 || upper && x <= 0.0) {
                    cp = Math.log(1.0 - Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp);
                }
            } else {
                p = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp;
                cp = 1.0 - p;
            }
            if (x > 0.0) {
                temp = p;
                if (lower) {
                    p = cp;
                }
                cp = temp;
            }
        } else if (x > 0.0) {
            p = 1.0;
            cp = 0.0;
        } else {
            p = 0.0;
            cp = 1.0;
        }
        return p;
    }

    public static double inverseErf(double z) {
        return NormalDistribution.pointNormal(0.5 * z + 0.5) / Math.sqrt(2.0);
    }

    private static double pointNormal(double prob) {
        double p1;
        double a0 = -0.322232431088;
        double a1 = -1.0;
        double a2 = -0.342242088547;
        double a3 = -0.0204231210245;
        double a4 = -4.53642210148E-5;
        double b0 = 0.099348462606;
        double b1 = 0.588581570495;
        double b2 = 0.531103462366;
        double b3 = 0.10353775285;
        double b4 = 0.0038560700634;
        double z = 0.0;
        double p = prob;
        double d = p1 = p < 0.5 ? p : 1.0 - p;
        if (p1 < 1.0E-20) {
            new IllegalArgumentException("Argument prob out of range");
        }
        double y = Math.sqrt(Math.log(1.0 / (p1 * p1)));
        z = y + ((((y * a4 + a3) * y + a2) * y + a1) * y + a0) / ((((y * b4 + b3) * y + b2) * y + b1) * y + b0);
        return p < 0.5 ? -z : z;
    }
}

