/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.scl;

import java.util.Collections;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationContext;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationRequest;
import org.simantics.db.layer0.util.RuntimeEnvironmentRequest;
import org.simantics.db.layer0.util.RuntimeEnvironmentRequest2;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.structural2.scl.ComponentTypeProperty;
import org.simantics.structural2.scl.ReadComponentTypeInterfaceRequest;

public abstract class AbstractCompileStructuralValueRequest
extends AbstractExpressionCompilationRequest<CompilationContext, org.simantics.db.layer0.variable.Variable> {
    protected final Resource relation;

    public AbstractCompileStructuralValueRequest(Resource relation) {
        this.relation = relation;
    }

    protected abstract String getExpressionText(ReadGraph var1) throws DatabaseException;

    protected abstract Resource getIndexRoot(ReadGraph var1) throws DatabaseException;

    protected abstract Resource getComponentType(ReadGraph var1) throws DatabaseException;

    protected Type getExpectedType(ReadGraph graph, CompilationContext context) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String valueType = (String)graph.getPossibleRelatedValue(this.relation, L0.RequiresValueType, (Binding)Bindings.STRING);
        if (valueType != null) {
            Resource relationIndexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(this.relation));
            RuntimeEnvironment relationRuntimeEnvironment = relationIndexRoot != null ? (RuntimeEnvironment)graph.syncRequest((Read)new RuntimeEnvironmentRequest(relationIndexRoot)) : context.runtimeEnvironment;
            try {
                return Environments.getType((Environment)relationRuntimeEnvironment.getEnvironment(), (String)valueType);
            }
            catch (SCLExpressionCompilationException e) {
                e.printStackTrace();
            }
        }
        return super.getExpectedType(graph, (AbstractExpressionCompilationContext)context);
    }

    protected CompilationContext getCompilationContext(ReadGraph graph) throws DatabaseException {
        Resource indexRoot = this.getIndexRoot(graph);
        Resource componentType = this.getComponentType(graph);
        if (componentType == null) {
            RuntimeEnvironment runtimeEnvironment = (RuntimeEnvironment)graph.syncRequest((Read)new RuntimeEnvironmentRequest(indexRoot));
            return new CompilationContext(runtimeEnvironment, Collections.emptyMap());
        }
        return (CompilationContext)((Object)graph.syncRequest((Read)new ResourceRead2<CompilationContext>(componentType, indexRoot){

            public CompilationContext perform(ReadGraph graph) throws DatabaseException {
                RuntimeEnvironment runtimeEnvironment = (RuntimeEnvironment)graph.syncRequest((Read)new RuntimeEnvironmentRequest2(this.resource, this.resource2));
                Map propertyMap = (Map)graph.syncRequest((Read)new ReadComponentTypeInterfaceRequest(this.resource, runtimeEnvironment.getEnvironment()), (Listener)TransientCacheListener.instance());
                return new CompilationContext(runtimeEnvironment, propertyMap);
            }
        }));
    }

    protected Type getContextVariableType() {
        return VARIABLE;
    }

    protected static Expression accessInputVariable(Environment environment, Variable contextVariable) {
        SCLValue variableParentFunction = environment.getValue(VARIABLE_PARENT);
        return new EApply((Expression)new EConstant(variableParentFunction), (Expression)new EApply((Expression)new EConstant(variableParentFunction), (Expression)new EVariable(contextVariable)));
    }

    protected Expression getVariableAccessExpression(ReadGraph graph, CompilationContext context, Variable contextVariable, String name) throws DatabaseException {
        ComponentTypeProperty property = context.propertyMap.get(name);
        if (property != null) {
            Environment environment = context.runtimeEnvironment.getEnvironment();
            return AbstractCompileStructuralValueRequest.getPropertyFlexible((Environment)environment, (Expression)AbstractCompileStructuralValueRequest.accessInputVariable(environment, contextVariable), (String)name, (Type)property.type);
        }
        if (name.equals("input")) {
            Environment environment = context.runtimeEnvironment.getEnvironment();
            return AbstractCompileStructuralValueRequest.accessInputVariable(environment, contextVariable);
        }
        if (name.equals("self")) {
            return new EVariable(contextVariable);
        }
        return null;
    }

    public static class CompilationContext
    extends AbstractExpressionCompilationContext {
        public final Map<String, ComponentTypeProperty> propertyMap;

        public CompilationContext(RuntimeEnvironment runtimeEnvironment, Map<String, ComponentTypeProperty> propertyMap) {
            super(runtimeEnvironment);
            this.propertyMap = propertyMap;
        }
    }
}

