/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.sensitivity;

import java.util.HashMap;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ITrackedColorProvider;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.jfreechart.chart.properties.DoubleValidator;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.SysdynBasicColorProvider;
import org.simantics.sysdyn.ui.properties.widgets.factories.DoublePropertyFactory;
import org.simantics.sysdyn.ui.properties.widgets.factories.DoublePropertyModifier;
import org.simantics.sysdyn.ui.properties.widgets.sensitivity.IDistributionProperties;
import org.simantics.sysdyn.ui.properties.widgets.sensitivity.SensitivityDistributionKeys;

public class NormalDistributionProperties
implements IDistributionProperties {
    private TrackedText minValue;
    private TrackedText maxValue;
    private TrackedText mean;
    private TrackedText stdDeviation;
    private Resource resource;

    public NormalDistributionProperties(Resource resource) {
        this.resource = resource;
    }

    @Override
    public Composite createContent(Composite parent, ISessionContext context, WidgetSupport support) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(composite);
        Label label = new Label(composite, 0);
        label.setText("Mean (\u03bc)");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)label);
        this.mean = new TrackedText(composite, support, 2048);
        this.mean.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/NormalDistribution/mean"));
        this.mean.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/NormalDistribution/mean"));
        this.mean.setInputValidator((IInputValidator)new DoubleValidator(true));
        this.mean.setColorProvider((ITrackedColorProvider)new SysdynBasicColorProvider((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), (Control)this.mean.getWidget())));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mean.getWidget());
        label = new Label(composite, 0);
        label.setText("Min value");
        GridDataFactory.fillDefaults().indent(15, 0).align(0x1000008, 0x1000000).applyTo((Control)label);
        this.minValue = new TrackedText(composite, support, 2048);
        this.minValue.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/NormalDistribution/minValue"));
        this.minValue.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/NormalDistribution/minValue"));
        this.minValue.setInputValidator((IInputValidator)new DoubleValidator(true));
        this.minValue.setColorProvider((ITrackedColorProvider)new SysdynBasicColorProvider((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), (Control)this.minValue.getWidget())));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.minValue.getWidget());
        label = new Label(composite, 0);
        label.setText("Standard deviation (\u03c3)");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)label);
        this.stdDeviation = new TrackedText(composite, support, 2048);
        this.stdDeviation.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/NormalDistribution/stdDeviation"));
        this.stdDeviation.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/NormalDistribution/stdDeviation"));
        this.stdDeviation.setInputValidator((IInputValidator)new DoubleValidator(true));
        this.stdDeviation.setColorProvider((ITrackedColorProvider)new SysdynBasicColorProvider((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), (Control)this.stdDeviation.getWidget())));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.stdDeviation.getWidget());
        label = new Label(composite, 0);
        label.setText("Max value");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)label);
        this.maxValue = new TrackedText(composite, support, 2048);
        this.maxValue.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/NormalDistribution/maxValue"));
        this.maxValue.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/NormalDistribution/maxValue"));
        this.maxValue.setInputValidator((IInputValidator)new DoubleValidator(true));
        this.maxValue.setColorProvider((ITrackedColorProvider)new SysdynBasicColorProvider((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), (Control)this.maxValue.getWidget())));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.maxValue.getWidget());
        return composite;
    }

    @Override
    public void getCachedValues(HashMap<String, String> cahcedValues) {
        if (!this.minValue.isDisposed()) {
            cahcedValues.put(SensitivityDistributionKeys.MIN, this.minValue.getText());
        }
        if (!this.maxValue.isDisposed()) {
            cahcedValues.put(SensitivityDistributionKeys.MAX, this.maxValue.getText());
        }
        if (!this.mean.isDisposed()) {
            cahcedValues.put(SensitivityDistributionKeys.MEAN, this.mean.getText());
        }
        if (!this.stdDeviation.isDisposed()) {
            cahcedValues.put(SensitivityDistributionKeys.STD_DEVIATION, this.stdDeviation.getText());
        }
    }

    @Override
    public void applyCache(WriteGraph graph, HashMap<String, String> cachedValues) throws DatabaseException {
        String stdDeviation;
        String mean;
        String max;
        if (this.resource == null) {
            return;
        }
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        String min = cachedValues.get(SensitivityDistributionKeys.MIN);
        if (min != null) {
            try {
                Double d = Double.parseDouble(min);
                graph.claimLiteral(this.resource, SR.NormalDistribution_minValue, (Object)d, (Binding)Bindings.DOUBLE);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((max = cachedValues.get(SensitivityDistributionKeys.MAX)) != null) {
            try {
                Double d = Double.parseDouble(max);
                graph.claimLiteral(this.resource, SR.NormalDistribution_maxValue, (Object)d, (Binding)Bindings.DOUBLE);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((mean = cachedValues.get(SensitivityDistributionKeys.MEAN)) != null) {
            try {
                Double d = Double.parseDouble(mean);
                graph.claimLiteral(this.resource, SR.NormalDistribution_mean, (Object)d, (Binding)Bindings.DOUBLE);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((stdDeviation = cachedValues.get(SensitivityDistributionKeys.STD_DEVIATION)) != null) {
            try {
                Double d = Double.parseDouble(stdDeviation);
                graph.claimLiteral(this.resource, SR.NormalDistribution_stdDeviation, (Object)d, (Binding)Bindings.DOUBLE);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

