/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.expressions;

import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteResult;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.ui.properties.widgets.expressions.BasicExpression;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionField;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionWidgetInput;
import org.simantics.sysdyn.ui.utils.ExpressionUtils;
import org.simantics.ui.SimanticsUI;

public class ParameterExpression
extends BasicExpression {
    Variable variable;

    public ParameterExpression(ExpressionWidgetInput input) {
        super(input);
        try {
            this.expressionType = (Resource)SimanticsUI.getSession().syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    return SysdynResource.getInstance((ReadGraph)graph).ParameterExpression;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.variable = input.variable;
    }

    @Override
    public void createExpressionFields(Composite parent, Map<String, Object> data, Table allowedVariables) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        String equation = data.get("equation") != null ? (String)data.get("equation") : "";
        Label l = new Label(parent, 0);
        l.setText("=");
        this.expression = new ExpressionField(parent, 2048, null, false, this.input);
        this.expression.setExpression(equation);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.expression);
    }

    @Override
    public void readData(Resource expression, Map<String, Object> data) {
        IExperimentManager manager = (IExperimentManager)SimanticsUI.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment == null || !(experiment instanceof SysdynGameExperimentBase)) {
            super.readData(expression, data);
        } else {
            ExperimentState state = ((SysdynGameExperimentBase)experiment).getSysdynExperimentState();
            if (ExperimentState.RUNNING.equals((Object)state) || ExperimentState.STOPPED.equals((Object)state)) {
                try {
                    Double value = (Double)SimanticsUI.getSession().syncRequest((Read)new Read<Double>(){

                        public Double perform(ReadGraph graph) throws DatabaseException {
                            try {
                                Variable valuesVariable = ParameterExpression.this.variable.browsePossible(graph, "#value#");
                                double[] res = (double[])valuesVariable.getValue(graph);
                                if (res != null && res.length == 1) {
                                    return res[0];
                                }
                                return null;
                            }
                            catch (DatabaseException e) {
                                throw new DatabaseException(e.getMessage());
                            }
                        }
                    });
                    if (value != null) {
                        data.put("equation", value.toString());
                    }
                }
                catch (DatabaseException databaseException) {}
            }
            super.readData(expression, data);
        }
    }

    @Override
    public void save(Resource expression, Map<String, Object> data) {
        IExperimentManager manager = (IExperimentManager)SimanticsUI.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment != null && experiment instanceof SysdynGameExperimentBase) {
            final String currentText = this.expression.getExpression();
            String oldEquation = (String)data.get("equation");
            if ((oldEquation == null || currentText != null && oldEquation != null && !currentText.equals(oldEquation) && this.expressionType != null) && ExpressionUtils.isParameter(currentText)) {
                Boolean savedIntoFMU = false;
                ExperimentState state = ((SysdynGameExperimentBase)experiment).getSysdynExperimentState();
                if (ExperimentState.RUNNING.equals((Object)state) || ExperimentState.STOPPED.equals((Object)state)) {
                    try {
                        savedIntoFMU = (Boolean)SimanticsUI.getSession().syncRequest((WriteResult)new WriteResultRequest<Boolean>(){

                            public Boolean perform(WriteGraph graph) throws DatabaseException {
                                try {
                                    Variable valuesVariable = ParameterExpression.this.variable.browsePossible((ReadGraph)graph, "#value#");
                                    if (valuesVariable == null) {
                                        return false;
                                    }
                                    valuesVariable.setValue(graph, (Object)new double[]{Double.parseDouble(currentText)});
                                    graph.markUndoPoint();
                                    CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                                    graph.addMetadata((Metadata)cm.add("Set parameter"));
                                    return true;
                                }
                                catch (Exception exception) {
                                    return false;
                                }
                            }
                        });
                    }
                    catch (DatabaseException databaseException) {}
                }
                if (savedIntoFMU.booleanValue()) {
                    data.put("equation", currentText);
                    return;
                }
            }
        }
        super.save(expression, data);
    }

    public ParameterExpression() {
        super(null);
        try {
            this.expressionType = (Resource)SimanticsUI.getSession().syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    return SysdynResource.getInstance((ReadGraph)graph).ParameterExpression;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }
}

