/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.simantics.sysdyn.ui.properties.widgets.FontModifyListener;

public class FontSelectionComposite
extends Composite {
    protected Text fontName;
    protected Text fontStyle;
    protected Text fontSize;
    protected ArrayList<String> familyIndex = new ArrayList();
    protected TreeMap<String, ArrayList<Font>> fonts = FontSelectionComposite.getFonts(this.familyIndex);
    protected Table fontFamilyTable;
    protected Table fontStyleTable;
    protected Table fontSizeTable;
    protected String[] sizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "24", "26", "28", "36", "48", "72"};
    private ListenerList modifyListeners;
    private final LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);

    private static TreeMap<String, ArrayList<Font>> getFonts(ArrayList<String> familyIndex) {
        Font[] allFonts;
        TreeMap<String, ArrayList<Font>> fonts = new TreeMap<String, ArrayList<Font>>();
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = allFonts = gEnv.getAllFonts();
        int n = allFonts.length;
        int n2 = 0;
        while (n2 < n) {
            Font font = fontArray[n2];
            String family = font.getFamily(Locale.ROOT);
            if (!fonts.containsKey(family)) {
                if (familyIndex != null) {
                    familyIndex.add(family);
                }
                fonts.put(family, new ArrayList());
            }
            boolean add = true;
            for (Font f : fonts.get(family)) {
                if (!f.getFontName().equals(font.getFontName())) continue;
                add = false;
                break;
            }
            if (add) {
                fonts.get(family).add(font);
            }
            ++n2;
        }
        return fonts;
    }

    public FontSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.modifyListeners = new ListenerList();
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo((Composite)this);
        GridDataFactory.fillDefaults().applyTo((Control)this);
        this.fontName = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().applyTo((Control)this.fontName);
        this.fontStyle = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().applyTo((Control)this.fontStyle);
        this.fontSize = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().applyTo((Control)this.fontSize);
        this.fontFamilyTable = new Table((Composite)this, 0x10010800);
        this.fontFamilyTable.setLinesVisible(false);
        this.fontFamilyTable.setHeaderVisible(false);
        GridDataFactory.fillDefaults().hint(-1, 100).applyTo((Control)this.fontFamilyTable);
        this.fontFamilyTable.setItemCount(this.familyIndex.size());
        TableColumn column = new TableColumn(this.fontFamilyTable, 0);
        column.setWidth(200);
        this.fontStyleTable = new Table((Composite)this, 67584);
        this.fontStyleTable.setLinesVisible(false);
        this.fontStyleTable.setHeaderVisible(false);
        GridDataFactory.fillDefaults().hint(100, 100).applyTo((Control)this.fontStyleTable);
        column = new TableColumn(this.fontStyleTable, 0);
        this.setFontStyleTableWidth();
        this.fontSizeTable = new Table((Composite)this, 0x10010800);
        this.fontSizeTable.setLinesVisible(false);
        this.fontSizeTable.setHeaderVisible(false);
        GridDataFactory.fillDefaults().hint(-1, 100).applyTo((Control)this.fontSizeTable);
        column = new TableColumn(this.fontSizeTable, 0);
        column.setWidth(70);
        String[] stringArray = this.sizes;
        int n = this.sizes.length;
        int n2 = 0;
        while (n2 < n) {
            String size = stringArray[n2];
            TableItem item = new TableItem(this.fontSizeTable, 0);
            item.setText(0, size);
            ++n2;
        }
        this.addFontFamilyListeners();
        this.addFontStyleListeners();
        this.addFontSizeListeners();
    }

    public void setFont(Font font, boolean notify) {
        if (font == null) {
            return;
        }
        Object[] listeners = new Object[]{};
        if (!notify) {
            Object[] objectArray = listeners = this.modifyListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                this.modifyListeners.remove(listener);
                ++n2;
            }
        }
        String fontFamily = font.getFamily(Locale.ROOT);
        String fontName = font.getFontName(Locale.ROOT);
        this.fontName.setText(fontFamily);
        this.fontFamilyTable.setTopIndex(this.fontFamilyTable.getSelectionIndex());
        String style = "Regular";
        if (fontName.length() > fontFamily.length()) {
            style = fontName.substring(fontFamily.length() + 1);
        }
        this.fontStyle.setText(style);
        int size = font.getSize();
        this.fontSize.setText("" + size);
        int i = 0;
        while (i < this.sizes.length) {
            if (this.sizes[i].equals("" + size)) {
                this.fontSizeTable.select(i);
                this.fontSizeTable.setTopIndex(i);
                this.fontChanged();
                break;
            }
            ++i;
        }
        if (!notify) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n3 = 0;
            while (n3 < n) {
                Object listener = objectArray[n3];
                this.modifyListeners.add(listener);
                ++n3;
            }
        }
    }

    public Font getAWTFont() {
        String family = this.fontName.getText();
        String style = this.fontStyle.getText();
        if (style.equals("Regular")) {
            style = null;
        }
        int stylebits = 0;
        if (style != null) {
            if (style.toLowerCase().contains("bold")) {
                stylebits |= 1;
            }
            if (style.toLowerCase().contains("italic")) {
                stylebits |= 2;
            }
        }
        String name = String.valueOf(family) + (style != null ? " " + style : "");
        int size = 10;
        try {
            size = Integer.parseInt(this.fontSize.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        if (name != null && name.length() > 0) {
            return new Font(name, stylebits, size);
        }
        return null;
    }

    protected void addFontFamilyListeners() {
        this.fontName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                String name = text.getText();
                FontSelectionComposite.this.fontFamilyTextModified(name, false);
            }
        });
        this.fontName.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ' && (e.stateMask & 0x40000) != 0) {
                    FontSelectionComposite.this.fontFamilyTextModified(FontSelectionComposite.this.fontName.getText(), true);
                    e.doit = false;
                } else if (e.keyCode == 13 || e.keyCode == 10 || e.keyCode == 0x1000050) {
                    FontSelectionComposite.this.fontChanged();
                }
            }
        });
        this.fontName.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                FontSelectionComposite.this.fontChanged();
            }
        });
        this.fontFamilyTable.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                int index = FontSelectionComposite.this.fontFamilyTable.indexOf(item);
                String family = FontSelectionComposite.this.familyIndex.get(index);
                item.setText(family);
                Font font = FontSelectionComposite.this.fonts.get(family).get(0);
                if (font.canDisplay('a')) {
                    FontData fontData = FontSelectionComposite.toSwtFontData(font, 10);
                    org.eclipse.swt.graphics.Font swtFont = FontSelectionComposite.this.resourceManager.createFont(FontDescriptor.createFrom((FontData)fontData));
                    item.setFont(swtFont);
                }
            }
        });
        this.fontFamilyTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = FontSelectionComposite.this.fontFamilyTable.getSelection();
                if (selection.length > 0) {
                    String family = selection[0].getText();
                    FontSelectionComposite.this.fontName.setText(family);
                    FontSelectionComposite.this.fontChanged();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fontFamilyTable.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (Character.isLetter(e.character)) {
                    FontSelectionComposite.this.fontName.forceFocus();
                    FontSelectionComposite.this.fontName.setTextChars(new char[]{e.character});
                    FontSelectionComposite.this.fontName.setSelection(1, 1);
                }
            }
        });
    }

    protected void fontFamilyTextModified(String name, boolean autoComplete) {
        if (name.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.familyIndex.size()) {
            String family = this.familyIndex.get(i);
            if (family.equals(name)) {
                this.fontFamilyTable.select(i);
                this.selectFontFamily(name);
                break;
            }
            if (family.toLowerCase().equals(name.toLowerCase())) {
                this.fontName.setText(family);
                this.fontName.setSelection(family.length(), family.length());
                this.fontFamilyTable.setTopIndex(i);
                this.fontChanged();
                break;
            }
            if (family.toLowerCase().startsWith(name.toLowerCase())) {
                if (autoComplete) {
                    this.fontName.setText(family);
                    this.fontName.setSelection(family.length());
                    this.fontChanged();
                    break;
                }
                this.fontFamilyTable.setTopIndex(i);
                break;
            }
            ++i;
        }
    }

    protected void addFontStyleListeners() {
        this.fontStyle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                String name = text.getText();
                FontSelectionComposite.this.fontStyleTextModified(name, false);
            }
        });
        this.fontStyle.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ' && (e.stateMask & 0x40000) != 0) {
                    FontSelectionComposite.this.fontStyleTextModified(FontSelectionComposite.this.fontStyle.getText(), true);
                    e.doit = false;
                } else if (e.keyCode == 13 || e.keyCode == 10 || e.keyCode == 0x1000050) {
                    FontSelectionComposite.this.fontChanged();
                }
            }
        });
        this.fontStyleTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = FontSelectionComposite.this.fontStyleTable.getSelection();
                if (selection.length > 0) {
                    String family = selection[0].getText();
                    FontSelectionComposite.this.fontStyle.setText(family);
                    FontSelectionComposite.this.fontChanged();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fontStyleTable.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (Character.isLetter(e.character)) {
                    FontSelectionComposite.this.fontStyle.forceFocus();
                    FontSelectionComposite.this.fontStyle.setTextChars(new char[]{e.character});
                    FontSelectionComposite.this.fontStyle.setSelection(1, 1);
                    e.doit = false;
                } else if (e.keyCode == 13 || e.keyCode == 10 || e.keyCode == 0x1000050) {
                    FontSelectionComposite.this.fontChanged();
                }
            }
        });
    }

    protected void fontStyleTextModified(String name, boolean autoComplete) {
        if (name.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.fontStyleTable.getItemCount()) {
            TableItem item = this.fontStyleTable.getItem(i);
            String style = item.getText();
            if (style.equals(name)) {
                this.fontStyleTable.select(i);
                break;
            }
            if (style.toLowerCase().equals(name.toLowerCase())) {
                this.fontStyle.setText(style);
                this.fontStyle.setSelection(style.length());
                this.fontStyleTable.setTopIndex(i);
                this.fontChanged();
                break;
            }
            if (style.toLowerCase().startsWith(name.toLowerCase())) {
                this.fontStyleTable.setTopIndex(i);
                if (autoComplete) {
                    this.fontStyle.setText(style);
                    this.fontStyle.setSelection(style.length());
                    this.fontChanged();
                    break;
                }
                this.fontStyleTable.setTopIndex(i);
                break;
            }
            ++i;
        }
    }

    protected void addFontSizeListeners() {
        this.fontSize.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                Text text = (Text)e.widget;
                String size = text.getText();
                int i = 0;
                while (i < FontSelectionComposite.this.sizes.length) {
                    if (FontSelectionComposite.this.sizes[i].equals(size)) {
                        FontSelectionComposite.this.fontSizeTable.select(i);
                        FontSelectionComposite.this.fontSizeTable.setTopIndex(i);
                        FontSelectionComposite.this.fontChanged();
                        break;
                    }
                    ++i;
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fontSizeTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FontSelectionComposite.this.fontSize.setText(FontSelectionComposite.this.fontSizeTable.getSelection()[0].getText());
                FontSelectionComposite.this.fontChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fontSizeTable.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (Character.isDigit(e.character)) {
                    FontSelectionComposite.this.fontSize.setTextChars(new char[]{e.character});
                    FontSelectionComposite.this.fontSize.setSelection(1);
                    FontSelectionComposite.this.fontSize.forceFocus();
                    e.doit = false;
                }
            }
        });
    }

    protected void selectFontFamily(String family) {
        String old = this.fontStyle.getText();
        String selection = null;
        String optionalSelection = null;
        this.fontStyleTable.removeAll();
        if (this.familyIndex.indexOf(family) > -1) {
            int i = 0;
            while (i < this.fonts.get(family).size()) {
                Font font = this.fonts.get(family).get(i);
                String name = font.getFontName(Locale.ROOT);
                String style = "Regular";
                if (name.length() > family.length()) {
                    style = name.substring(family.length() + 1);
                }
                if (old.equals(style)) {
                    selection = style;
                } else if (!old.isEmpty() && style.contains(old) || optionalSelection == null) {
                    optionalSelection = style;
                }
                TableItem item = new TableItem(this.fontStyleTable, 0);
                item.setText(0, style);
                item.setData((Object)font);
                if (font.canDisplay('a')) {
                    FontData fontData = FontSelectionComposite.toSwtFontData(font, 10);
                    org.eclipse.swt.graphics.Font swtFont = this.resourceManager.createFont(FontDescriptor.createFrom((FontData)fontData));
                    item.setFont(swtFont);
                }
                ++i;
            }
            this.fontStyleTable.setItemCount(this.fonts.get(family).size());
            if (selection == null) {
                selection = optionalSelection;
            }
            this.fontStyle.setText(selection);
            this.fontStyle.setSelection(selection.length(), selection.length());
            this.setFontStyleTableWidth();
        }
    }

    protected void setFontStyleTableWidth() {
        Rectangle area = this.fontStyleTable.getClientArea();
        Point size = this.fontStyleTable.computeSize(-1, -1);
        ScrollBar vBar = this.fontStyleTable.getVerticalBar();
        int width = 100;
        if (area.height == 0 || size.y <= area.height) {
            Point vBarSize = vBar.getSize();
            width += vBarSize.x;
        }
        this.fontStyleTable.getColumn(0).setWidth(width);
    }

    protected static FontData toSwtFontData(Font font, int height) {
        FontData fontData = new FontData();
        fontData.setName(font.getFontName());
        fontData.setStyle(font.getStyle());
        fontData.setHeight(height > 0 ? height : font.getSize());
        return fontData;
    }

    public void addFontModifiedListener(FontModifyListener listener) {
        this.modifyListeners.add((Object)listener);
    }

    public void removeFontModifiedListener(FontModifyListener listener) {
        this.modifyListeners.remove((Object)listener);
    }

    public List<FontModifyListener> getFontModifiedListener() {
        ArrayList<FontModifyListener> listeners = new ArrayList<FontModifyListener>(this.modifyListeners.size());
        Object[] objectArray = this.modifyListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            listeners.add((FontModifyListener)l);
            ++n2;
        }
        return listeners;
    }

    protected void fontChanged() {
        Font font = this.getAWTFont();
        if (font != null) {
            int style = 0;
            style |= font.getFontName(Locale.ROOT).contains("Bold") ? 1 : 0;
            FontData fontData = new FontData(font.getFamily(Locale.ROOT), font.getSize(), style |= font.getFontName(Locale.ROOT).contains("Italic") ? 2 : 0);
            Object[] listenersArray = this.modifyListeners.getListeners();
            int i = 0;
            while (i < listenersArray.length) {
                ((FontModifyListener)listenersArray[i]).awtFontChanged(font);
                ((FontModifyListener)listenersArray[i]).swtFontDataChanged(fontData);
                ++i;
            }
        }
    }
}

