/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.actions.drop;

import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.SingleObjectWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.jfreechart.chart.ChartUtils;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.AdaptionUtils;

public class ChartDropAction
implements DropActionFactory {
    public Runnable create(ReadGraph g, Object target, Object source, int operation) throws DatabaseException {
        final Resource targetChart = (Resource)AdaptionUtils.adaptToSingle((Object)target, Resource.class);
        if (targetChart == null || source == null || !(source instanceof IStructuredSelection)) {
            return null;
        }
        final IStructuredSelection selection = (IStructuredSelection)source;
        return new Runnable(){

            @Override
            public void run() {
                SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        JFreeChartResource JFREE = JFreeChartResource.getInstance((ReadGraph)graph);
                        Iterator iterator = selection.iterator();
                        while (iterator.hasNext()) {
                            Resource plot;
                            Resource represents;
                            Variable variable = (Variable)AdaptionUtils.adaptToSingle(iterator.next(), Variable.class);
                            if (variable == null || (represents = variable.getRepresents((ReadGraph)graph)) == null || !graph.isInstanceOf(represents, sr.IndependentVariable) && !graph.isInstanceOf(represents, sr.Input) || (plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(targetChart, L0.ConsistsOf, JFREE.Plot))) == null) continue;
                            if (graph.isInstanceOf(plot, JFREE.XYPlot)) {
                                ChartDropAction.this.dropToLineChart(graph, targetChart, variable);
                                continue;
                            }
                            if (graph.isInstanceOf(plot, JFREE.CategoryPlot)) {
                                ChartDropAction.this.dropToBarChart(graph, targetChart, variable);
                                continue;
                            }
                            if (!graph.isInstanceOf(plot, JFREE.PiePlot)) continue;
                            ChartDropAction.this.dropToPieChart(graph, targetChart, variable);
                        }
                    }
                });
            }
        };
    }

    private void dropToPieChart(WriteGraph graph, Resource pieChart, Variable variable) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        Resource plot = (Resource)graph.syncRequest((Read)new SingleObjectWithType(pieChart, l0.ConsistsOf, jfree.Plot));
        if (plot == null) {
            return;
        }
        Resource dataset = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(plot, l0.ConsistsOf, jfree.Dataset));
        if (dataset == null) {
            return;
        }
        String rvi = Variables.getRVI((ReadGraph)graph, (Variable)variable);
        Resource series = ChartUtils.createSeries((WriteGraph)graph, (Resource)dataset, (String)rvi);
        graph.claimLiteral(series, jfree.Series_exploded, (Object)false);
    }

    private void dropToBarChart(WriteGraph graph, Resource barChart, Variable variable) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        Resource plot = (Resource)graph.syncRequest((Read)new SingleObjectWithType(barChart, l0.ConsistsOf, jfree.Plot));
        if (plot == null) {
            return;
        }
        Resource dataset = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(plot, l0.ConsistsOf, jfree.Dataset));
        if (dataset == null) {
            return;
        }
        String rvi = Variables.getRVI((ReadGraph)graph, (Variable)variable);
        ChartUtils.createSeries((WriteGraph)graph, (Resource)dataset, (String)rvi);
    }

    private void dropToLineChart(WriteGraph graph, Resource lineChart, Variable variable) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        Resource plot = (Resource)graph.syncRequest((Read)new SingleObjectWithType(lineChart, l0.ConsistsOf, jfree.Plot));
        if (plot == null) {
            return;
        }
        Resource rangeAxis = null;
        Resource dataset = null;
        Resource rangeAxisList = graph.getPossibleObject(plot, jfree.Plot_rangeAxisList);
        if (rangeAxisList == null || ListUtils.toList((ReadGraph)graph, (Resource)rangeAxisList).isEmpty()) {
            rangeAxis = ChartUtils.createNumberRangeAxis((WriteGraph)graph, (Resource)plot);
            Resource domainAxis = graph.getPossibleObject(plot, jfree.Plot_domainAxis);
            dataset = ChartUtils.createXYDataset((WriteGraph)graph, (Resource)plot, (Resource)domainAxis, (Resource)rangeAxis);
        } else {
            rangeAxis = (Resource)ListUtils.toList((ReadGraph)graph, (Resource)rangeAxisList).get(0);
            dataset = graph.getPossibleObject(rangeAxis, jfree.Dataset_mapToRangeAxis_Inverse);
        }
        String rvi = Variables.getRVI((ReadGraph)graph, (Variable)variable);
        ChartUtils.createSeries((WriteGraph)graph, (Resource)dataset, (String)rvi);
    }
}

