/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.diagram.handler.ElementType;
import org.simantics.diagram.handler.IElementAssortment;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.elementclass.BranchPoint;
import org.simantics.g2d.elementclass.FlagHandler;
import org.simantics.g2d.elementclass.MonitorHandler;
import org.simantics.g2d.elementclass.NonCopyable;
import org.simantics.g2d.elementclass.ReferenceElement;

public class ElementAssortment
implements IElementAssortment {
    public Set<IElement> all;
    public final List<IElement> nodeList = new ArrayList<IElement>();
    public final Set<IElement> nodes = new HashSet<IElement>();
    public final Set<IElement> connections = new HashSet<IElement>();
    public final Set<IElement> edges = new HashSet<IElement>();
    public final Set<IElement> branchPoints = new HashSet<IElement>();
    public final Set<IElement> flags = new HashSet<IElement>();
    public final Set<IElement> references = new HashSet<IElement>();
    public final Set<IElement> monitors = new HashSet<IElement>();
    public final Set<IElement> others = new HashSet<IElement>();
    public final Set<IElement> noncopyables = new HashSet<IElement>();
    EnumSet<ElementType> contents;

    public ElementAssortment(Set<IElement> set) {
        if (set == null) {
            throw new IllegalArgumentException("null element set");
        }
        this.all = new HashSet<IElement>(set);
        this.sort(set);
    }

    private void sort(Set<IElement> set) {
        EnumSet<ElementType> es = EnumSet.noneOf(ElementType.class);
        this.contents = es;
        for (IElement el : set) {
            ElementClass ec = el.getElementClass();
            NonCopyable nc = (NonCopyable)ec.getAtMostOneItemOfClass(NonCopyable.class);
            ReferenceElement re = (ReferenceElement)ec.getAtMostOneItemOfClass(ReferenceElement.class);
            MonitorHandler mh = (MonitorHandler)ec.getAtMostOneItemOfClass(MonitorHandler.class);
            FlagHandler fh = (FlagHandler)ec.getAtMostOneItemOfClass(FlagHandler.class);
            TerminalTopology tt = (TerminalTopology)ec.getAtMostOneItemOfClass(TerminalTopology.class);
            BendsHandler bh = (BendsHandler)ec.getAtMostOneItemOfClass(BendsHandler.class);
            BranchPoint bp = (BranchPoint)ec.getAtMostOneItemOfClass(BranchPoint.class);
            ConnectionHandler ch = (ConnectionHandler)ec.getAtMostOneItemOfClass(ConnectionHandler.class);
            if (nc != null) {
                this.noncopyables.add(el);
                es.add(ElementType.NonCopyable);
                this.all.remove(el);
                continue;
            }
            if (mh != null) {
                this.monitors.add(el);
                es.add(ElementType.Monitor);
                continue;
            }
            if (re != null) {
                this.references.add(el);
                es.add(ElementType.Reference);
                continue;
            }
            if (fh != null) {
                this.flags.add(el);
                es.add(ElementType.Flag);
                continue;
            }
            if (ch != null) {
                this.connections.add(el);
                es.add(ElementType.Connection);
                continue;
            }
            if (bp != null) {
                this.branchPoints.add(el);
                es.add(ElementType.BranchPoint);
                continue;
            }
            if (tt != null) {
                this.nodes.add(el);
                this.nodeList.add(el);
                es.add(ElementType.Node);
                continue;
            }
            if (bh != null) {
                this.edges.add(el);
                es.add(ElementType.Edge);
                continue;
            }
            this.others.add(el);
            es.add(ElementType.Other);
        }
    }

    public Set<IElement> getAll() {
        return new HashSet<IElement>(this.all);
    }

    @Override
    public boolean contains(ElementType et) {
        return this.contents.contains((Object)et);
    }

    @Override
    public boolean contains(Collection<ElementType> ets) {
        return this.contents.containsAll(ets);
    }

    @Override
    public boolean containsAny(Collection<ElementType> ets) {
        for (ElementType et : ets) {
            if (!this.contents.contains((Object)et)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int count(ElementType et) {
        switch (et) {
            case BranchPoint: {
                return this.branchPoints.size();
            }
            case Connection: {
                return this.connections.size();
            }
            case Edge: {
                return this.edges.size();
            }
            case Flag: {
                return this.flags.size();
            }
            case Monitor: {
                return this.monitors.size();
            }
            case Reference: {
                return this.references.size();
            }
            case Node: {
                return this.nodes.size();
            }
            case Other: {
                return this.others.size();
            }
            case NonCopyable: {
                return this.noncopyables.size();
            }
        }
        return 0;
    }

    boolean add(ElementType et) {
        return this.contents.add(et);
    }

    boolean remove(ElementType et) {
        return this.contents.remove((Object)et);
    }

    private boolean addType(Set<IElement> set, IElement e, ElementType et) {
        if (this.all.add(e)) {
            boolean ret = set.add(e);
            if (ret) {
                this.contents.add(et);
            }
            return ret;
        }
        return false;
    }

    private boolean removeType(Set<IElement> set, IElement e, ElementType et) {
        if (this.all.remove(e)) {
            boolean ret = set.remove(e);
            if (set.isEmpty()) {
                this.contents.remove((Object)et);
            }
            return ret;
        }
        return false;
    }

    private int removeAllType(Set<IElement> set, Collection<IElement> es, ElementType et) {
        int result = 0;
        for (IElement e : es) {
            if (!this.removeType(set, e, et)) continue;
            ++result;
        }
        return result;
    }

    private int clearType(Set<IElement> set, ElementType et) {
        int ret = set.size();
        this.all.removeAll(set);
        this.contents.remove((Object)et);
        return ret;
    }

    public int clear(ElementType et) {
        switch (et) {
            case BranchPoint: {
                return this.clearType(this.branchPoints, et);
            }
            case Connection: {
                return this.clearType(this.connections, et);
            }
            case Edge: {
                return this.clearType(this.edges, et);
            }
            case Flag: {
                return this.clearType(this.flags, et);
            }
            case Monitor: {
                return this.clearType(this.monitors, et);
            }
            case Reference: {
                return this.clearType(this.references, et);
            }
            case Node: {
                return this.clearType(this.nodes, et);
            }
            case Other: {
                return this.clearType(this.others, et);
            }
            case NonCopyable: {
                return this.clearType(this.noncopyables, et);
            }
        }
        return 0;
    }

    public boolean add(ElementType et, IElement e) {
        switch (et) {
            case BranchPoint: {
                return this.addType(this.branchPoints, e, et);
            }
            case Connection: {
                return this.addType(this.connections, e, et);
            }
            case Edge: {
                return this.addType(this.edges, e, et);
            }
            case Flag: {
                return this.addType(this.flags, e, et);
            }
            case Monitor: {
                return this.addType(this.monitors, e, et);
            }
            case Reference: {
                return this.addType(this.references, e, et);
            }
            case Node: {
                return this.addType(this.nodes, e, et);
            }
            case Other: {
                return this.addType(this.others, e, et);
            }
            case NonCopyable: {
                return this.addType(this.noncopyables, e, et);
            }
        }
        return false;
    }

    boolean remove(ElementType et, IElement e) {
        switch (et) {
            case BranchPoint: {
                return this.removeType(this.branchPoints, e, et);
            }
            case Connection: {
                return this.removeType(this.connections, e, et);
            }
            case Edge: {
                return this.removeType(this.edges, e, et);
            }
            case Flag: {
                return this.removeType(this.flags, e, et);
            }
            case Monitor: {
                return this.removeType(this.monitors, e, et);
            }
            case Reference: {
                return this.removeType(this.references, e, et);
            }
            case Node: {
                return this.removeType(this.nodes, e, et);
            }
            case Other: {
                return this.removeType(this.others, e, et);
            }
            case NonCopyable: {
                return this.removeType(this.noncopyables, e, et);
            }
        }
        return false;
    }

    public int removeAll(ElementType et, Collection<IElement> es) {
        if (es.isEmpty()) {
            return 0;
        }
        switch (et) {
            case BranchPoint: {
                return this.removeAllType(this.branchPoints, es, et);
            }
            case Connection: {
                return this.removeAllType(this.connections, es, et);
            }
            case Edge: {
                return this.removeAllType(this.edges, es, et);
            }
            case Flag: {
                return this.removeAllType(this.flags, es, et);
            }
            case Monitor: {
                return this.removeAllType(this.monitors, es, et);
            }
            case Reference: {
                return this.removeAllType(this.references, es, et);
            }
            case Node: {
                return this.removeAllType(this.nodes, es, et);
            }
            case Other: {
                return this.removeAllType(this.others, es, et);
            }
            case NonCopyable: {
                return this.removeAllType(this.noncopyables, es, et);
            }
        }
        return 0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ElementAssortment:\n");
        b.append("\t CONTAINS: ");
        b.append(this.contents);
        b.append("\n");
        for (IElement e : this.nodes) {
            b.append("\t-node " + e + "\n");
        }
        for (IElement e : this.connections) {
            b.append("\t-connection " + e + "\n");
        }
        for (IElement e : this.edges) {
            b.append("\t-edge " + e + "\n");
        }
        for (IElement e : this.branchPoints) {
            b.append("\t-branch " + e + "\n");
        }
        for (IElement e : this.flags) {
            b.append("\t-flag " + e + "\n");
        }
        for (IElement e : this.references) {
            b.append("\t-reference " + e + "\n");
        }
        for (IElement e : this.monitors) {
            b.append("\t-monitor " + e + "\n");
        }
        for (IElement e : this.others) {
            b.append("\t-other " + e + "\n");
        }
        for (IElement e : this.noncopyables) {
            b.append("\t-non-copyable " + e + "\n");
        }
        return b.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.all.isEmpty();
    }
}

