/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.function;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.annotation.ontology.AnnotationResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.SimanticsUI;

public class PredefinedVariables {
    public static final String root = "root";
    public static final String project = "project";
    public static final String model = "model";
    public static final String template = "template";
    public static final String current = ".";
    public static final String diagramComposite = "diagramComposite";
    public static final String diagram = "diagram";
    public static final String flagAnnotation = "annotation";
    public static final String flagSourceObject = "flagSourceObject";
    public static final String flagTargetObject = "flagTargetObject";
    public static final String flagSourceComposite = "flagSourceComposite";
    public static final String flagTargetComposite = "flagTargetComposite";
    public static final String flagRouterComponent = "flagRouterComponent";
    private static PredefinedVariables factory = new PredefinedVariables();
    Resource connectedComponent = null;

    public static PredefinedVariables getInstance() {
        return factory;
    }

    public static void setFactory(PredefinedVariables factory) {
        PredefinedVariables.factory = factory;
    }

    private Resource getConnectedComponent(ReadGraph graph, Resource flag) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        ConnectionUtil cu = new ConnectionUtil(graph);
        Resource connectedComponent = null;
        HashSet<Resource> connectors = new HashSet<Resource>();
        block0: for (Resource connector : graph.getObjects(flag, STR.IsConnectedTo)) {
            Resource diagramConnection = ConnectionUtil.tryGetConnection(graph, connector);
            if (diagramConnection == null) continue;
            connectors.clear();
            cu.getConnectors(diagramConnection, connectors);
            connectors.remove(connector);
            if (connectors.isEmpty() || connectedComponent != null) continue;
            for (Resource conn : connectors) {
                Resource element = cu.getConnectedComponent(diagramConnection, conn);
                if (element != null && (connectedComponent = graph.getPossibleObject(element, MOD.ElementToComponent)) != null) continue block0;
            }
        }
        return connectedComponent;
    }

    public Resource getFlagRouterComponent(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource flag = variable.getPossibleRepresents(graph);
        return flag == null ? null : this.getFlagRouterComponent(graph, flag);
    }

    public Resource getFlagRouterComponent(ReadGraph graph, Resource flag) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource container = graph.getSingleObject(flag, L0.PartOf);
        Resource composite = graph.getSingleObject(container, MOD.DiagramToComposite);
        Variable var = Variables.getVariable((ReadGraph)graph, (Resource)composite);
        Variable result = FlagUtil.getPossibleFlagSignal(graph, var, flag, L0.Entity);
        if (result != null) {
            return result.getRepresents(graph);
        }
        return null;
    }

    private Resource getFlagTargetObject(ReadGraph graph, Variable variable) {
        Resource connectedComponent;
        block7: {
            Resource targetFlag;
            block6: {
                Set<Resource> targetFlags;
                block5: {
                    try {
                        Resource flag = variable.getRepresents(graph);
                        targetFlags = FlagUtil.getCounterparts(graph, flag);
                        if (targetFlags.size() == 1) break block5;
                        return null;
                    }
                    catch (DatabaseException databaseException) {
                        return null;
                    }
                }
                targetFlag = targetFlags.toArray(new Resource[0])[0];
                if (targetFlag != null) break block6;
                return null;
            }
            connectedComponent = this.getConnectedComponent(graph, targetFlag);
            if (connectedComponent != null) break block7;
            return null;
        }
        return connectedComponent;
    }

    private Resource getFlagSourceObject(ReadGraph graph, Variable variable) {
        Resource connectedComponent;
        block3: {
            try {
                Resource flag = variable.getRepresents(graph);
                connectedComponent = this.getConnectedComponent(graph, flag);
                if (connectedComponent != null) break block3;
                return null;
            }
            catch (DatabaseException databaseException) {
                return null;
            }
        }
        return connectedComponent;
    }

    private Resource getFlagSourceComposite(ReadGraph graph, Variable variable) {
        Resource composite;
        block5: {
            Resource diagram;
            ModelingResources MOD;
            block4: {
                try {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    MOD = ModelingResources.getInstance((ReadGraph)graph);
                    Resource flag = variable.getRepresents(graph);
                    diagram = graph.getPossibleObject(flag, L0.PartOf);
                    if (diagram != null) break block4;
                    return null;
                }
                catch (DatabaseException databaseException) {
                    return null;
                }
            }
            composite = graph.getPossibleObject(diagram, MOD.DiagramToComposite);
            if (composite != null) break block5;
            return null;
        }
        return composite;
    }

    private Resource getFlagTargetComposite(ReadGraph graph, Variable variable) {
        Resource composite;
        block9: {
            Resource diagram;
            ModelingResources MOD;
            block8: {
                Resource targetFlag;
                Layer0 L0;
                block7: {
                    Set<Resource> targetFlags;
                    block6: {
                        try {
                            L0 = Layer0.getInstance((ReadGraph)graph);
                            MOD = ModelingResources.getInstance((ReadGraph)graph);
                            Resource flag = variable.getRepresents(graph);
                            targetFlags = FlagUtil.getCounterparts(graph, flag);
                            if (targetFlags.size() == 1) break block6;
                            return null;
                        }
                        catch (DatabaseException databaseException) {
                            return null;
                        }
                    }
                    targetFlag = targetFlags.toArray(new Resource[0])[0];
                    if (targetFlag != null) break block7;
                    return null;
                }
                diagram = graph.getPossibleObject(targetFlag, L0.PartOf);
                if (diagram != null) break block8;
                return null;
            }
            composite = graph.getPossibleObject(diagram, MOD.DiagramToComposite);
            if (composite != null) break block9;
            return null;
        }
        return composite;
    }

    public static Resource getAnnotation(ReadGraph graph, Resource res) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection children = graph.getObjects(res, L0.ConsistsOf);
        Resource anno = null;
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        for (Resource child : children) {
            if (!graph.isInstanceOf(child, ANNO.Annotation)) continue;
            anno = child;
            break;
        }
        return anno;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Resource getDiagramComposite(ReadGraph graph, Variable variable) {
        Resource parent;
        ModelingResources MOD;
        block7: {
            DiagramResource DIA;
            block6: {
                Resource res;
                block5: {
                    try {
                        res = variable.getRepresents(graph);
                        if (res != null) break block5;
                        return null;
                    }
                    catch (DatabaseException databaseException) {
                        return null;
                    }
                }
                DIA = DiagramResource.getInstance((ReadGraph)graph);
                if (!graph.isInstanceOf(res, DIA.Flag)) return res;
                MOD = ModelingResources.getInstance((ReadGraph)graph);
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                parent = graph.getPossibleObject(res, L0.PartOf);
                if (parent != null) break block6;
                return null;
            }
            if (graph.isInstanceOf(parent, DIA.Diagram)) break block7;
            return null;
        }
        return graph.getPossibleObject(parent, MOD.DiagramToComposite);
    }

    public Resource getPredefinedResource(ReadGraph graph, Variable selection, String id) throws DatabaseException {
        Resource predefined = null;
        if (id.equals(root)) {
            predefined = graph.getRootLibrary();
        } else if (id.equals(project)) {
            predefined = (Resource)SimanticsUI.getProject().get();
        } else if (id.equals(model)) {
            predefined = Variables.getPossibleModel((ReadGraph)graph, (Variable)selection);
        } else if (id.equals(template)) {
            Resource composite = selection.getRepresents(graph);
            if (composite == null) {
                return null;
            }
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Template2dResource TEPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
            Resource diagram = graph.getPossibleObject(composite, MOD.CompositeToDiagram);
            if (diagram == null) {
                return null;
            }
            predefined = graph.getPossibleObject(diagram, TEPLATE2D.HasDrawingTemplate);
        } else if (id.equals(current)) {
            predefined = selection.getPossibleRepresents(graph);
        } else if (id.equals(flagAnnotation)) {
            Resource flag = selection.getPossibleRepresents(graph);
            if (flag != null) {
                predefined = PredefinedVariables.getAnnotation(graph, flag);
            }
        } else if (id.equals(diagram)) {
            Resource composite = selection.getPossibleRepresents(graph);
            if (composite == null) {
                return null;
            }
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            predefined = graph.getPossibleObject(composite, MOD.CompositeToDiagram);
        } else if (id.equals(diagramComposite)) {
            predefined = this.getDiagramComposite(graph, selection);
        } else if (id.equals(flagSourceObject)) {
            predefined = this.getFlagSourceObject(graph, selection);
        } else if (id.equals(flagTargetObject)) {
            predefined = this.getFlagTargetObject(graph, selection);
        } else if (id.equals(flagSourceComposite)) {
            predefined = this.getFlagSourceComposite(graph, selection);
        } else if (id.equals(flagTargetComposite)) {
            predefined = this.getFlagTargetComposite(graph, selection);
        } else if (id.equals(flagRouterComponent)) {
            predefined = this.getFlagRouterComponent(graph, selection);
        }
        return predefined;
    }

    public Variable getPredefinedVariable(ReadGraph graph, Variable selection, String id) throws DatabaseException {
        Resource predefined = this.getPredefinedResource(graph, selection, id);
        if (predefined == null) {
            return null;
        }
        Variable v = selection;
        if (predefined != null) {
            v = Variables.getPossibleVariable((ReadGraph)graph, (Resource)predefined);
        }
        return v;
    }

    public Variable getVariable(ReadGraph graph, String path, Resource converter, Variable selection) throws DatabaseException {
        if (path == null) {
            return null;
        }
        int colonInx = path.indexOf(58);
        int firstSlash = path.indexOf(47);
        int firstHash = path.indexOf(35);
        int firstFlashInx = firstSlash;
        if (firstFlashInx == -1) {
            firstFlashInx = firstHash;
        } else if (firstHash > -1 && firstHash < firstFlashInx) {
            firstFlashInx = firstHash;
        }
        String predefined = null;
        String relativePath = null;
        if (colonInx != -1 && firstFlashInx != -1 && colonInx + 1 == firstFlashInx && path.length() > firstFlashInx + 1) {
            String scheme = path.substring(0, colonInx);
            String absPath = path.substring(firstFlashInx + 1);
            if (scheme.equals("pre")) {
                int endOfPredefined1 = absPath.indexOf(47);
                int endOfPredefined2 = absPath.indexOf(35);
                if (endOfPredefined1 == -1 && endOfPredefined2 == -1) {
                    predefined = absPath;
                }
                if (endOfPredefined1 == -1 && endOfPredefined2 != -1) {
                    predefined = absPath.substring(0, endOfPredefined2);
                }
                if (endOfPredefined1 != -1 && endOfPredefined2 == -1) {
                    predefined = absPath.substring(0, endOfPredefined1);
                }
                if (endOfPredefined1 != -1 && endOfPredefined2 != -1) {
                    if (endOfPredefined2 < endOfPredefined1) {
                        endOfPredefined1 = endOfPredefined2;
                    }
                    predefined = absPath.substring(0, endOfPredefined1);
                }
                relativePath = absPath.substring(predefined.length());
            }
        }
        if (selection == null) {
            return null;
        }
        Variable v = selection;
        if (predefined != null) {
            v = this.getPredefinedVariable(graph, selection, predefined);
        }
        if (v == null) {
            return null;
        }
        Variable property = null;
        if (relativePath != null) {
            if (relativePath.startsWith("/.")) {
                relativePath = relativePath.substring(1);
            }
            property = v.browsePossible(graph, relativePath);
        } else {
            property = v.browsePossible(graph, path);
        }
        return property;
    }
}

