/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.diagram.elements.ITextContentFilter;
import org.simantics.diagram.elements.ITextListener;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.profile.MonitorTextGridResult;
import org.simantics.scenegraph.ExportableWidget;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.Decoration;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.scl.runtime.function.Function1;

@ExportableWidget.OutputWidget(value={"textGrid"})
public class TextGridNode
extends G2DParentNode
implements Decoration {
    private static final int CACHED_COLUMNS = 4;
    private static final int CACHED_ROWS = 10;
    private static Cell[][] cache = new Cell[10][];
    private static final long serialVersionUID = 7015425802228571055L;
    private TMap<Cell, A> nodes = new THashMap();
    private TIntObjectMap<String> rowIds = new TIntObjectHashMap();
    private boolean up = true;
    private boolean dragging = false;
    private Point2D dragBegin = null;
    private Point2D currentDrag = null;
    private Function1<Vec2d, Boolean> translator = null;
    private static double FACTOR;
    private static double FACTOR2;

    static {
        int row = 0;
        while (row < 10) {
            TextGridNode.cache[row] = new Cell[4];
            int col = 0;
            while (col < 4) {
                TextGridNode.cache[row][col] = new Cell(col + 1, row + 1);
                ++col;
            }
            ++row;
        }
        FACTOR = 1.0;
        FACTOR2 = 7.0;
    }

    private static String makeId(int x, int y) {
        return String.valueOf(x) + "#" + y;
    }

    private int computeRows() {
        MaxY maxy = new MaxY();
        this.nodes.forEachKey((TObjectProcedure)maxy);
        return maxy.max;
    }

    private List<Cell> peekRowCells(int y) {
        ArrayList<Cell> row = new ArrayList<Cell>(4);
        for (Cell key : this.nodes.keySet()) {
            if (key.y != y) continue;
            row.add(key);
        }
        return row;
    }

    public void setUp(boolean up) {
        this.up = up;
    }

    public A get(int x, int y) {
        Cell p = Cell.make(x, y);
        A node = (A)((Object)this.nodes.get((Object)p));
        if (node == null) {
            node = (A)((Object)this.getOrCreateNode(p.toString(), A.class));
            node.setZIndex(x + (y - 1) * 100);
            this.nodes.put((Object)p, (Object)node);
        }
        return node;
    }

    public MonitorTextGridResult getCache(int x, int y) {
        return this.get(x, y).getCache();
    }

    public void setCache(int x, int y, MonitorTextGridResult cache) {
        this.get(x, y).setCache(cache);
    }

    public void setTransform(int x, int y, AffineTransform transform) {
        this.get(x, y).setTransform(transform);
        this.dragBegin = null;
        this.currentDrag = null;
    }

    public void setHorizontalAlignment(int x, int y, byte horizontalAlignment) {
        this.get(x, y).setHorizontalAlignment(horizontalAlignment);
    }

    public void setVerticalAlignment(int x, int y, byte verticalAlignment) {
        this.get(x, y).setVerticalAlignment(verticalAlignment);
    }

    public void setForceEventListening(int x, int y, boolean force) {
        this.get(x, y).setForceEventListening(force);
    }

    public void setEditable(int x, int y, boolean editable) {
        this.get(x, y).setEditable(editable);
    }

    public void setTextListener(int x, int y, ITextListener listener) {
        this.get(x, y).setTextListener(listener);
    }

    public void setInputValidator(int x, int y, Function1<String, String> validator) {
        this.get(x, y).setValidator(validator);
    }

    public void setTranslator(Function1<Vec2d, Boolean> translator) {
        this.translator = translator;
    }

    public void setContentFilter(int x, int y, ITextContentFilter filter) {
        this.get(x, y).setContentFilter(filter);
    }

    public void setRVI(int x, int y, RVI rvi) {
        this.get(x, y).setRVI(rvi);
    }

    public void setBackgroundColor(int x, int y, Color color) {
        this.get(x, y).setBackgroundColor(color);
    }

    @INode.SyncField(value={"font"})
    public void setFont(int x, int y, Font font) {
        this.get(x, y).setFont(font);
    }

    @INode.SyncField(value={"text"})
    public void setText(int x, int y, String text) {
        this.get(x, y).setText(text);
    }

    @INode.SyncField(value={"text"})
    public void setPending(int x, int y, boolean pending) {
        this.get(x, y).setPending(pending);
    }

    @INode.SyncField(value={"color"})
    public void setColor(int x, int y, Color color) {
        this.get(x, y).setColor(color);
    }

    public void removeRow(int y) {
        List<Cell> row = this.peekRowCells(y);
        if (row.isEmpty()) {
            return;
        }
        for (Cell cell : row) {
            this.nodes.remove((Object)cell);
            this.removeNode(cell.toString());
        }
    }

    public void setRowId(int y, String id) {
        this.rowIds.put(y, (Object)id);
    }

    public String getRowId(int y) {
        return (String)this.rowIds.get(y);
    }

    public void render(Graphics2D g2d) {
        Vec2d delta = this.getDelta(FACTOR);
        if (delta != null) {
            this.setTransform(AffineTransform.getTranslateInstance(delta.x, delta.y - 2.1 * (double)this.computeRows() * (this.up ? 1.0 : 0.0)));
        } else {
            this.setTransform(AffineTransform.getTranslateInstance(0.0, -2.1 * (double)this.computeRows() * (this.up ? 1.0 : 0.0)));
        }
        super.render(g2d);
    }

    public Rectangle2D getBoundsInLocal(boolean b) {
        return null;
    }

    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    public Rectangle2D getBounds() {
        return null;
    }

    public int getEventMask() {
        return EventTypes.MouseDragBeginMask | EventTypes.MouseMovedMask | EventTypes.MouseButtonReleasedMask | EventTypes.KeyPressedMask;
    }

    private static boolean isEventDummy(MouseEvent.MouseDragBegin e) {
        return e.controlPosition.distance(0.0, 0.0) == 0.0 && e.screenPosition.distance(0.0, 0.0) == 0.0 && e.buttons == 0;
    }

    private Vec2d getDelta(double factor) {
        if (this.dragBegin != null && this.currentDrag != null) {
            double dx = factor * (this.currentDrag.getX() - this.dragBegin.getX());
            double dy = factor * (this.currentDrag.getY() - this.dragBegin.getY());
            return new Vec2d(dx, dy);
        }
        return null;
    }

    protected boolean keyPressed(KeyEvent.KeyPressedEvent e) {
        if (this.dragging && e.keyCode == 27) {
            this.dragBegin = null;
            this.currentDrag = null;
            this.dragging = false;
            this.repaint();
            return true;
        }
        return false;
    }

    protected boolean mouseMoved(MouseEvent.MouseMovedEvent event) {
        if (this.dragging) {
            this.currentDrag = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)event.controlPosition, (Point2D)new Point2D.Double());
            this.repaint();
        }
        return false;
    }

    protected boolean hitTest(MouseEvent event, double tolerance) {
        Rectangle2D bounds = super.getBoundsInLocal(false);
        if (bounds == null) {
            return false;
        }
        Point2D localPos = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)event.controlPosition, (Point2D)new Point2D.Double());
        double x = localPos.getX();
        double y = localPos.getY() + 2.1 * (double)this.computeRows() * (this.up ? 1.0 : 0.0);
        boolean hit = bounds.contains(x, y);
        return hit;
    }

    protected boolean mouseDragged(MouseEvent.MouseDragBegin e) {
        if (TextGridNode.isEventDummy(e)) {
            return false;
        }
        G2DSceneGraph sg = NodeUtil.getRootNode((IG2DNode)this);
        Boolean b = (Boolean)sg.getGlobalProperty("ignoreFocus", (Object)false);
        if (!b.booleanValue()) {
            return false;
        }
        if (!e.hasAnyButton(1) || e.hasAnyModifier(8896) || !this.hitTest((MouseEvent)e, 0.0)) {
            return false;
        }
        this.dragBegin = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)e.controlPosition, (Point2D)new Point2D.Double());
        this.dragging = true;
        return true;
    }

    protected boolean mouseButtonReleased(MouseEvent.MouseButtonReleasedEvent e) {
        if (!this.dragging) {
            return false;
        }
        Vec2d delta = this.getDelta(FACTOR2);
        if (delta != null && this.translator != null) {
            this.translator.apply((Object)delta);
        } else {
            this.dragBegin = null;
            this.currentDrag = null;
        }
        this.dragging = false;
        return false;
    }

    public void init() {
        super.init();
        this.addEventHandler((IEventHandler)this);
    }

    public void cleanup() {
        this.removeEventHandler((IEventHandler)this);
        super.cleanup();
    }

    public static class A
    extends TextNode {
        MonitorTextGridResult cache = null;
        private static final long serialVersionUID = -4519849713591842241L;

        public MonitorTextGridResult getCache() {
            return this.cache;
        }

        public void setCache(MonitorTextGridResult cache) {
            this.cache = cache;
        }
    }

    static class Cell {
        public final int x;
        public final int y;

        public Cell(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (Cell.class != object.getClass()) {
                return false;
            }
            Cell p = (Cell)object;
            return this.x == p.x && this.y == p.y;
        }

        public int hashCode() {
            return this.x * 31 + this.y;
        }

        public String toString() {
            return TextGridNode.makeId(this.x, this.y);
        }

        public static Cell make(int x, int y) {
            if (x >= 1 && x <= 4 && y >= 1 && y <= 10) {
                return cache[y - 1][x - 1];
            }
            return new Cell(x, y);
        }
    }

    static class MaxY
    implements TObjectProcedure<Cell> {
        int max = 0;

        MaxY() {
        }

        public boolean execute(Cell key) {
            if (key.y > this.max) {
                this.max = key.y;
            }
            return true;
        }
    }
}

