/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithSupertype;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.symbolcontribution.AbstractSymbolProvider;
import org.simantics.diagram.symbolcontribution.ElementSymbolItem;
import org.simantics.diagram.symbolcontribution.ISymbolProvider;
import org.simantics.diagram.symbolcontribution.ModifiableSymbolGroup;
import org.simantics.diagram.symbolcontribution.SymbolGroup;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactories;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactory;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.layer0.Layer0;

public class BasicSymbolProviderFactory
implements SymbolProviderFactory {
    Resource contribution;
    Resource diagram;

    public BasicSymbolProviderFactory(Resource contribution, Resource diagram) {
        this.contribution = contribution;
        this.diagram = diagram;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.contribution == null ? 0 : this.contribution.hashCode());
        result = 31 * result + (this.diagram == null ? 0 : this.diagram.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicSymbolProviderFactory other = (BasicSymbolProviderFactory)obj;
        if (this.contribution == null ? other.contribution != null : !this.contribution.equals(other.contribution)) {
            return false;
        }
        return !(this.diagram == null ? other.diagram != null : !this.diagram.equals(other.diagram));
    }

    @Override
    public ISymbolProvider create(ReadGraph g) throws DatabaseException {
        return (ISymbolProvider)g.syncRequest((Read)new LoadRequest(this.contribution, this.diagram));
    }

    static SymbolGroup createGroup(ReadGraph graph, Resource library, Resource relation, Resource diagram) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        String name = BasicSymbolProviderFactory.safeName(graph, library);
        String description = (String)graph.getPossibleRelatedValue2(library, l0.HasDescription, (Binding)Bindings.STRING);
        if (description == null) {
            description = name;
        }
        ModifiableSymbolGroup group = new ModifiableSymbolGroup((Object)library, name, description);
        ArrayList<ElementSymbolItem> items = new ArrayList<ElementSymbolItem>();
        for (Resource item : (Set)graph.syncRequest((Read)new ObjectsWithSupertype(library, relation, dr.Element))) {
            if (!SymbolProviderFactories.accept(graph, dr, item, diagram)) continue;
            String itemName = BasicSymbolProviderFactory.safeName(graph, item);
            String itemDescription = (String)graph.getPossibleRelatedValue2(item, l0.HasDescription, (Binding)Bindings.STRING);
            if (itemDescription == null || itemDescription.isEmpty()) {
                itemDescription = itemName;
            }
            items.add(new ElementSymbolItem(item, itemName, itemDescription, (ISymbolGroup)group));
        }
        Collections.sort(items, new Comparator<ISymbolItem>(){

            @Override
            public int compare(ISymbolItem o1, ISymbolItem o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        group.setItems(items.toArray(new ISymbolItem[items.size()]));
        return group;
    }

    private static String safeName(ReadGraph graph, Resource r) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue2(r, L0.HasLabel, (Binding)Bindings.STRING);
        if (name == null || name.isEmpty()) {
            name = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
        }
        if (name == null) {
            name = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
        }
        return name;
    }

    static class LoadRequest
    extends BinaryRead<Resource, Resource, ISymbolProvider> {
        public LoadRequest(Resource contribution, Resource diagram) {
            super((Object)contribution, (Object)diagram);
        }

        public ISymbolProvider perform(ReadGraph graph) throws DatabaseException {
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
            if (!SymbolProviderFactories.accept(graph, dr, (Resource)this.parameter, (Resource)this.parameter2)) {
                return new SymbolProvider(Collections.emptyList());
            }
            Collection libraries = graph.getObjects((Resource)this.parameter, dr.BasicSymbolContributionHasSymbolLibrary);
            ArrayList<ISymbolGroup> groups = new ArrayList<ISymbolGroup>(libraries.size());
            for (Resource library : libraries) {
                if (!SymbolProviderFactories.accept(graph, dr, library, (Resource)this.parameter2)) continue;
                groups.add(BasicSymbolProviderFactory.createGroup(graph, library, l0.DependsOn, (Resource)this.parameter2));
            }
            return new SymbolProvider(groups);
        }
    }

    static class SymbolProvider
    extends AbstractSymbolProvider {
        public SymbolProvider(Collection<ISymbolGroup> groups) {
            this.setSymbolGroup(groups);
            this.lockGroups();
        }
    }
}

