/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.services.adaption.reflection;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.services.adaption.reflection.IDynamicAdapter2;

public class AdaptingDynamicAdapter2
implements IDynamicAdapter2 {
    IDynamicAdapter2 adapter;
    Class<?> targetType;

    public AdaptingDynamicAdapter2(IDynamicAdapter2 adapter, Class<?> targetType) {
        this.adapter = adapter;
        this.targetType = targetType;
    }

    @Override
    public Object adapt(ReadGraph g, Resource r) throws DatabaseException {
        Object obj = this.adapter.adapt(g, r);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Resource) {
            return g.adapt((Resource)obj, this.targetType);
        }
        if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            ArrayList<Object> ret = new ArrayList<Object>(c.size());
            for (Object o : c) {
                ret.add(g.adapt((Resource)o, this.targetType));
            }
            return ret;
        }
        throw new AdaptionException("Invalid type.");
    }

    @Override
    public Class<?> getType() throws DatabaseException {
        if (this.adapter.getType().equals(Resource.class)) {
            return this.targetType;
        }
        if (this.adapter.getType().equals(Collection.class)) {
            return Collection.class;
        }
        throw new AdaptionException("Invalid type.");
    }
}

